# This script was automatically generated from the 288-4 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

These remote packages are missing security patches :
- dovecot-common 
- dovecot-imapd 
- dovecot-pop3d 


Description :

USN-288-3 fixed a vulnerability in dovecot. Unfortunately the Ubuntu
6.06 update had a regression which caused authentication using a MySQL
database to not work any more. This update fixes this again.

We apologize for the inconvenience.

Solution :

Upgrade to : 
- dovecot-common-1.0.beta3-3ubuntu5.2 (Ubuntu 6.06)
- dovecot-imapd-1.0.beta3-3ubuntu5.2 (Ubuntu 6.06)
- dovecot-pop3d-1.0.beta3-3ubuntu5.2 (Ubuntu 6.06)



Risk factor : High
';

if (description) {
script_id(27860);
script_version("$Revision: 1.1 $");
script_copyright("Ubuntu Security Notice (C) 2007 Canonical, Inc. / NASL script (C) 2007 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "288-4");
script_summary(english:"dovecot regression fix");
script_name(english:"USN288-4 : dovecot regression fix");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "6.06", pkgname: "dovecot-common", pkgver: "1.0.beta3-3ubuntu5.2");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package dovecot-common-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to dovecot-common-1.0.beta3-3ubuntu5.2
');
}
found = ubuntu_check(osver: "6.06", pkgname: "dovecot-imapd", pkgver: "1.0.beta3-3ubuntu5.2");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package dovecot-imapd-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to dovecot-imapd-1.0.beta3-3ubuntu5.2
');
}
found = ubuntu_check(osver: "6.06", pkgname: "dovecot-pop3d", pkgver: "1.0.beta3-3ubuntu5.2");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package dovecot-pop3d-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to dovecot-pop3d-1.0.beta3-3ubuntu5.2
');
}

if (w) { security_hole(port: 0, data: desc); }
