# This script was automatically generated from the 320-1 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

These remote packages are missing security patches :
- libapache2-mod-php4 
- libapache2-mod-php5 
- php-pear 
- php4 
- php4-cgi 
- php4-cli 
- php4-common 
- php4-dev 
- php5 
- php5-cgi 
- php5-cli 
- php5-common 
- php5-curl 
- php5-dev 
- php5-gd 
- php5-ldap 
- php5-mhash 
- php5-mysql 
- php5-mysqli 
- php5-odbc 
- php5-pgsql 
- php5-recode 
- php5-snmp 
- php5-sqlite 
- php5-sybase 
- php5-xmlrpc 
- php5-xsl 


Description :

The phpinfo() PHP function did not properly sanitize long strings. A
remote attacker could use this to perform cross-site scripting attacks
against sites that have publicly-available PHP scripts that call
phpinfo(). Please note that it is not recommended to publicly expose
phpinfo(). (CVE-2006-0996)

An information disclosure has been reported in the
html_entity_decode() function. A script which uses this function to
process arbitrary user-supplied input could be exploited to expose a
random part of memory, which could potentially reveal sensitive data.
(CVE-2006-1490)

The wordwrap() function did not sufficiently check the validity of the
\'break\' argument. An attacker who could control the string passed to
the \'break\' parameter could cause a heap overflow; however, this
should not happen in practical applications. (CVE-2006-1990)

The substr_compare() function did not sufficiently check the validity
of the \'offset\' argument. A script which passes untrusted user-defined
values to this parameter could b
[...]

Solution :

Upgrade to : 
- libapache2-mod-php4-4.3.10-10ubuntu4.5 (Ubuntu 5.04)
- libapache2-mod-php5-5.1.2-1ubuntu3.1 (Ubuntu 6.06)
- php-pear-5.1.2-1ubuntu3.1 (Ubuntu 6.06)
- php4-4.3.10-10ubuntu4.5 (Ubuntu 5.04)
- php4-cgi-4.3.10-10ubuntu4.5 (Ubuntu 5.04)
- php4-cli-4.3.10-10ubuntu4.5 (Ubuntu 5.04)
- php4-common-4.3.10-10ubuntu4.5 (Ubuntu 5.04)
- php4-dev-4.3.10-10ubuntu4.5 (Ubuntu 5.04)
- php5-5.1.2-1ubuntu3.1 (Ubuntu 6.06)
- php5-cgi-5.1.2-1ubuntu3.1 (Ubuntu 6.06)
- php5-cli-5.1.2-1ubuntu3.1 (Ubuntu 6.06)
- php5
[...]


Risk factor : High
';

if (description) {
script_id(27897);
script_version("$Revision: 1.1 $");
script_copyright("Ubuntu Security Notice (C) 2007 Canonical, Inc. / NASL script (C) 2007 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "320-1");
script_summary(english:"PHP vulnerabilities");
script_name(english:"USN320-1 : PHP vulnerabilities");
script_cve_id("CVE-2006-0996","CVE-2006-1490","CVE-2006-1494","CVE-2006-1608","CVE-2006-1990","CVE-2006-1991","CVE-2006-2563","CVE-2006-2660","CVE-2006-3011","CVE-2006-3016","CVE-2006-3017","CVE-2006-3018");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "5.04", pkgname: "libapache2-mod-php4", pkgver: "4.3.10-10ubuntu4.5");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libapache2-mod-php4-',found,' is vulnerable in Ubuntu 5.04
Upgrade it to libapache2-mod-php4-4.3.10-10ubuntu4.5
');
}
found = ubuntu_check(osver: "6.06", pkgname: "libapache2-mod-php5", pkgver: "5.1.2-1ubuntu3.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libapache2-mod-php5-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to libapache2-mod-php5-5.1.2-1ubuntu3.1
');
}
found = ubuntu_check(osver: "6.06", pkgname: "php-pear", pkgver: "5.1.2-1ubuntu3.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package php-pear-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to php-pear-5.1.2-1ubuntu3.1
');
}
found = ubuntu_check(osver: "5.04", pkgname: "php4", pkgver: "4.3.10-10ubuntu4.5");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package php4-',found,' is vulnerable in Ubuntu 5.04
Upgrade it to php4-4.3.10-10ubuntu4.5
');
}
found = ubuntu_check(osver: "5.04", pkgname: "php4-cgi", pkgver: "4.3.10-10ubuntu4.5");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package php4-cgi-',found,' is vulnerable in Ubuntu 5.04
Upgrade it to php4-cgi-4.3.10-10ubuntu4.5
');
}
found = ubuntu_check(osver: "5.04", pkgname: "php4-cli", pkgver: "4.3.10-10ubuntu4.5");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package php4-cli-',found,' is vulnerable in Ubuntu 5.04
Upgrade it to php4-cli-4.3.10-10ubuntu4.5
');
}
found = ubuntu_check(osver: "5.04", pkgname: "php4-common", pkgver: "4.3.10-10ubuntu4.5");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package php4-common-',found,' is vulnerable in Ubuntu 5.04
Upgrade it to php4-common-4.3.10-10ubuntu4.5
');
}
found = ubuntu_check(osver: "5.04", pkgname: "php4-dev", pkgver: "4.3.10-10ubuntu4.5");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package php4-dev-',found,' is vulnerable in Ubuntu 5.04
Upgrade it to php4-dev-4.3.10-10ubuntu4.5
');
}
found = ubuntu_check(osver: "6.06", pkgname: "php5", pkgver: "5.1.2-1ubuntu3.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package php5-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to php5-5.1.2-1ubuntu3.1
');
}
found = ubuntu_check(osver: "6.06", pkgname: "php5-cgi", pkgver: "5.1.2-1ubuntu3.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package php5-cgi-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to php5-cgi-5.1.2-1ubuntu3.1
');
}
found = ubuntu_check(osver: "6.06", pkgname: "php5-cli", pkgver: "5.1.2-1ubuntu3.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package php5-cli-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to php5-cli-5.1.2-1ubuntu3.1
');
}
found = ubuntu_check(osver: "6.06", pkgname: "php5-common", pkgver: "5.1.2-1ubuntu3.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package php5-common-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to php5-common-5.1.2-1ubuntu3.1
');
}
found = ubuntu_check(osver: "6.06", pkgname: "php5-curl", pkgver: "5.1.2-1ubuntu3.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package php5-curl-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to php5-curl-5.1.2-1ubuntu3.1
');
}
found = ubuntu_check(osver: "6.06", pkgname: "php5-dev", pkgver: "5.1.2-1ubuntu3.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package php5-dev-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to php5-dev-5.1.2-1ubuntu3.1
');
}
found = ubuntu_check(osver: "6.06", pkgname: "php5-gd", pkgver: "5.1.2-1ubuntu3.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package php5-gd-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to php5-gd-5.1.2-1ubuntu3.1
');
}
found = ubuntu_check(osver: "6.06", pkgname: "php5-ldap", pkgver: "5.1.2-1ubuntu3.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package php5-ldap-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to php5-ldap-5.1.2-1ubuntu3.1
');
}
found = ubuntu_check(osver: "6.06", pkgname: "php5-mhash", pkgver: "5.1.2-1ubuntu3.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package php5-mhash-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to php5-mhash-5.1.2-1ubuntu3.1
');
}
found = ubuntu_check(osver: "6.06", pkgname: "php5-mysql", pkgver: "5.1.2-1ubuntu3.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package php5-mysql-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to php5-mysql-5.1.2-1ubuntu3.1
');
}
found = ubuntu_check(osver: "6.06", pkgname: "php5-mysqli", pkgver: "5.1.2-1ubuntu3.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package php5-mysqli-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to php5-mysqli-5.1.2-1ubuntu3.1
');
}
found = ubuntu_check(osver: "6.06", pkgname: "php5-odbc", pkgver: "5.1.2-1ubuntu3.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package php5-odbc-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to php5-odbc-5.1.2-1ubuntu3.1
');
}
found = ubuntu_check(osver: "6.06", pkgname: "php5-pgsql", pkgver: "5.1.2-1ubuntu3.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package php5-pgsql-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to php5-pgsql-5.1.2-1ubuntu3.1
');
}
found = ubuntu_check(osver: "6.06", pkgname: "php5-recode", pkgver: "5.1.2-1ubuntu3.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package php5-recode-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to php5-recode-5.1.2-1ubuntu3.1
');
}
found = ubuntu_check(osver: "6.06", pkgname: "php5-snmp", pkgver: "5.1.2-1ubuntu3.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package php5-snmp-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to php5-snmp-5.1.2-1ubuntu3.1
');
}
found = ubuntu_check(osver: "6.06", pkgname: "php5-sqlite", pkgver: "5.1.2-1ubuntu3.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package php5-sqlite-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to php5-sqlite-5.1.2-1ubuntu3.1
');
}
found = ubuntu_check(osver: "6.06", pkgname: "php5-sybase", pkgver: "5.1.2-1ubuntu3.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package php5-sybase-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to php5-sybase-5.1.2-1ubuntu3.1
');
}
found = ubuntu_check(osver: "6.06", pkgname: "php5-xmlrpc", pkgver: "5.1.2-1ubuntu3.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package php5-xmlrpc-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to php5-xmlrpc-5.1.2-1ubuntu3.1
');
}
found = ubuntu_check(osver: "6.06", pkgname: "php5-xsl", pkgver: "5.1.2-1ubuntu3.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package php5-xsl-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to php5-xsl-5.1.2-1ubuntu3.1
');
}

if (w) { security_hole(port: 0, data: desc); }
