# This script was automatically generated from the 324-1 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

These remote packages are missing security patches :
- freetype2-demos 
- libfreetype6 
- libfreetype6-dev 


Description :

An integer overflow has been discovered in the FreeType library. By
tricking a user into installing and/or opening a specially crafted
font file, these could be exploited to execute arbitrary code with the
privileges of that user.

Solution :

Upgrade to : 
- freetype2-demos-2.1.10-1ubuntu2.2 (Ubuntu 6.06)
- libfreetype6-2.1.10-1ubuntu2.2 (Ubuntu 6.06)
- libfreetype6-dev-2.1.10-1ubuntu2.2 (Ubuntu 6.06)



Risk factor : High
';

if (description) {
script_id(27902);
script_version("$Revision: 1.1 $");
script_copyright("Ubuntu Security Notice (C) 2007 Canonical, Inc. / NASL script (C) 2007 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "324-1");
script_summary(english:"freetype vulnerability");
script_name(english:"USN324-1 : freetype vulnerability");
script_cve_id("CVE-2006-3467");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "6.06", pkgname: "freetype2-demos", pkgver: "2.1.10-1ubuntu2.2");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package freetype2-demos-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to freetype2-demos-2.1.10-1ubuntu2.2
');
}
found = ubuntu_check(osver: "6.06", pkgname: "libfreetype6", pkgver: "2.1.10-1ubuntu2.2");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libfreetype6-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to libfreetype6-2.1.10-1ubuntu2.2
');
}
found = ubuntu_check(osver: "6.06", pkgname: "libfreetype6-dev", pkgver: "2.1.10-1ubuntu2.2");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libfreetype6-dev-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to libfreetype6-dev-2.1.10-1ubuntu2.2
');
}

if (w) { security_hole(port: 0, data: desc); }
