# This script was automatically generated from the 327-1 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

These remote packages are missing security patches :
- firefox 
- firefox-dbg 
- firefox-dev 
- firefox-dom-inspector 
- firefox-gnome-support 
- libnspr-dev 
- libnspr4 
- libnss-dev 
- libnss3 
- mozilla-firefox 
- mozilla-firefox-dev 


Description :

Various flaws have been reported that allow an attacker to execute
arbitrary code with user privileges by tricking the user into opening
a malicious URL. (CVE-2006-3113, CVE-2006-3677, CVE-2006-3801,
CVE-2006-3803, CVE-2006-3805, CVE-2006-3806, CVE-2006-3807,
CVE-2006-3809, CVE-2006-3811, CVE-2006-3812)

cross-site scripting vulnerabilities were found in the
XPCNativeWrapper() function and native DOM method handlers. A
malicious web site could exploit these to modify the contents or steal
confidential data (such as passwords) from other opened web pages.
(CVE-2006-3802, CVE-2006-3810)

A bug was found in the script handler for automatic proxy
configuration. A malicious proxy could send scripts which could
execute arbitrary code with the user\'s privileges. (CVE-2006-3808)

Please see 

  http://www.mozilla.org/projects/security/known-vulnerabilities.html#Firefox

for technical details of these vulnerabilities.

Solution :

Upgrade to : 
- firefox-1.5.dfsg+1.5.0.5-0ubuntu6.06 (Ubuntu 6.06)
- firefox-dbg-1.5.dfsg+1.5.0.5-0ubuntu6.06 (Ubuntu 6.06)
- firefox-dev-1.5.dfsg+1.5.0.5-0ubuntu6.06 (Ubuntu 6.06)
- firefox-dom-inspector-1.5.dfsg+1.5.0.5-0ubuntu6.06 (Ubuntu 6.06)
- firefox-gnome-support-1.5.dfsg+1.5.0.5-0ubuntu6.06 (Ubuntu 6.06)
- libnspr-dev-1.firefox1.5.dfsg+1.5.0.5-0ubuntu6.06 (Ubuntu 6.06)
- libnspr4-1.firefox1.5.dfsg+1.5.0.5-0ubuntu6.06 (Ubuntu 6.06)
- libnss-dev-1.firefox1.5.dfsg+1.5.0.5-0ubuntu6.06 (Ubuntu 6.06)
- 
[...]


Risk factor : High
';

if (description) {
script_id(27905);
script_version("$Revision: 1.1 $");
script_copyright("Ubuntu Security Notice (C) 2007 Canonical, Inc. / NASL script (C) 2007 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "327-1");
script_summary(english:"firefox vulnerabilities");
script_name(english:"USN327-1 : firefox vulnerabilities");
script_cve_id("CVE-2006-3113","CVE-2006-3677","CVE-2006-3801","CVE-2006-3802","CVE-2006-3803","CVE-2006-3805","CVE-2006-3806","CVE-2006-3807","CVE-2006-3808","CVE-2006-3809","CVE-2006-3810","CVE-2006-3811","CVE-2006-3812");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "6.06", pkgname: "firefox", pkgver: "1.5.dfsg+1.5.0.5-0ubuntu6.06");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package firefox-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to firefox-1.5.dfsg+1.5.0.5-0ubuntu6.06
');
}
found = ubuntu_check(osver: "6.06", pkgname: "firefox-dbg", pkgver: "1.5.dfsg+1.5.0.5-0ubuntu6.06");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package firefox-dbg-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to firefox-dbg-1.5.dfsg+1.5.0.5-0ubuntu6.06
');
}
found = ubuntu_check(osver: "6.06", pkgname: "firefox-dev", pkgver: "1.5.dfsg+1.5.0.5-0ubuntu6.06");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package firefox-dev-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to firefox-dev-1.5.dfsg+1.5.0.5-0ubuntu6.06
');
}
found = ubuntu_check(osver: "6.06", pkgname: "firefox-dom-inspector", pkgver: "1.5.dfsg+1.5.0.5-0ubuntu6.06");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package firefox-dom-inspector-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to firefox-dom-inspector-1.5.dfsg+1.5.0.5-0ubuntu6.06
');
}
found = ubuntu_check(osver: "6.06", pkgname: "firefox-gnome-support", pkgver: "1.5.dfsg+1.5.0.5-0ubuntu6.06");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package firefox-gnome-support-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to firefox-gnome-support-1.5.dfsg+1.5.0.5-0ubuntu6.06
');
}
found = ubuntu_check(osver: "6.06", pkgname: "libnspr-dev", pkgver: "1.firefox1.5.dfsg+1.5.0.5-0ubuntu6.06");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libnspr-dev-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to libnspr-dev-1.firefox1.5.dfsg+1.5.0.5-0ubuntu6.06
');
}
found = ubuntu_check(osver: "6.06", pkgname: "libnspr4", pkgver: "1.firefox1.5.dfsg+1.5.0.5-0ubuntu6.06");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libnspr4-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to libnspr4-1.firefox1.5.dfsg+1.5.0.5-0ubuntu6.06
');
}
found = ubuntu_check(osver: "6.06", pkgname: "libnss-dev", pkgver: "1.firefox1.5.dfsg+1.5.0.5-0ubuntu6.06");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libnss-dev-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to libnss-dev-1.firefox1.5.dfsg+1.5.0.5-0ubuntu6.06
');
}
found = ubuntu_check(osver: "6.06", pkgname: "libnss3", pkgver: "1.firefox1.5.dfsg+1.5.0.5-0ubuntu6.06");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libnss3-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to libnss3-1.firefox1.5.dfsg+1.5.0.5-0ubuntu6.06
');
}
found = ubuntu_check(osver: "6.06", pkgname: "mozilla-firefox", pkgver: "1.5.dfsg+1.5.0.5-0ubuntu6.06");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package mozilla-firefox-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to mozilla-firefox-1.5.dfsg+1.5.0.5-0ubuntu6.06
');
}
found = ubuntu_check(osver: "6.06", pkgname: "mozilla-firefox-dev", pkgver: "1.5.dfsg+1.5.0.5-0ubuntu6.06");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package mozilla-firefox-dev-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to mozilla-firefox-dev-1.5.dfsg+1.5.0.5-0ubuntu6.06
');
}

if (w) { security_hole(port: 0, data: desc); }
