# This script was automatically generated from the 356-1 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

The remote package "gdb" is missing a security patch.

Description :

Will Drewry, of the Google Security Team, discovered buffer overflows
in GDB\'s DWARF processing.  This would allow an attacker to execute
arbitrary code with user privileges by tricking the user into using
GDB to load an executable that contained malicious debugging
information.

Solution :

Upgrade to : 
- gdb-6.4-1ubuntu5.1 (Ubuntu 6.06)



Risk factor : High
';

if (description) {
script_id(27936);
script_version("$Revision: 1.1 $");
script_copyright("Ubuntu Security Notice (C) 2007 Canonical, Inc. / NASL script (C) 2007 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "356-1");
script_summary(english:"gdb vulnerability");
script_name(english:"USN356-1 : gdb vulnerability");
script_cve_id("CVE-2006-4146");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "6.06", pkgname: "gdb", pkgver: "6.4-1ubuntu5.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package gdb-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to gdb-6.4-1ubuntu5.1
');
}

if (w) { security_hole(port: 0, data: desc); }
