# This script was automatically generated from the 357-1 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

These remote packages are missing security patches :
- libmono-dev 
- libmono0 
- mono 
- mono-assemblies-base 
- mono-classlib-1.0 
- mono-classlib-1.0-dbg 
- mono-classlib-2.0 
- mono-classlib-2.0-dbg 
- mono-common 
- mono-devel 
- mono-gac 
- mono-gmcs 
- mono-jay 
- mono-jit 
- mono-mcs 
- mono-utils 


Description :

Sebastian Krahmer of the SuSE security team discovered that the
System.CodeDom.Compiler classes used temporary files in an insecure
way. This could allow a symbolic link attack to create or overwrite
arbitrary files with the privileges of the user invoking the program.
Under some circumstances, a local attacker could also exploit this to
inject arbitrary code into running Mono processes.

Solution :

Upgrade to : 
- libmono-dev-1.1.13.6-0ubuntu3.1 (Ubuntu 6.06)
- libmono0-1.1.13.6-0ubuntu3.1 (Ubuntu 6.06)
- mono-1.1.13.6-0ubuntu3.1 (Ubuntu 6.06)
- mono-assemblies-base-1.1.13.6-0ubuntu3.1 (Ubuntu 6.06)
- mono-classlib-1.0-1.1.13.6-0ubuntu3.1 (Ubuntu 6.06)
- mono-classlib-1.0-dbg-1.1.13.6-0ubuntu3.1 (Ubuntu 6.06)
- mono-classlib-2.0-1.1.13.6-0ubuntu3.1 (Ubuntu 6.06)
- mono-classlib-2.0-dbg-1.1.13.6-0ubuntu3.1 (Ubuntu 6.06)
- mono-common-1.1.13.6-0ubuntu3.1 (Ubuntu 6.06)
- mono-devel-1.1.13.6-0ubuntu3.1 (
[...]


Risk factor : High
';

if (description) {
script_id(27937);
script_version("$Revision: 1.1 $");
script_copyright("Ubuntu Security Notice (C) 2007 Canonical, Inc. / NASL script (C) 2007 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "357-1");
script_summary(english:"Mono vulnerability");
script_name(english:"USN357-1 : Mono vulnerability");
script_cve_id("CVE-2006-5072");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "6.06", pkgname: "libmono-dev", pkgver: "1.1.13.6-0ubuntu3.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libmono-dev-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to libmono-dev-1.1.13.6-0ubuntu3.1
');
}
found = ubuntu_check(osver: "6.06", pkgname: "libmono0", pkgver: "1.1.13.6-0ubuntu3.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libmono0-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to libmono0-1.1.13.6-0ubuntu3.1
');
}
found = ubuntu_check(osver: "6.06", pkgname: "mono", pkgver: "1.1.13.6-0ubuntu3.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package mono-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to mono-1.1.13.6-0ubuntu3.1
');
}
found = ubuntu_check(osver: "6.06", pkgname: "mono-assemblies-base", pkgver: "1.1.13.6-0ubuntu3.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package mono-assemblies-base-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to mono-assemblies-base-1.1.13.6-0ubuntu3.1
');
}
found = ubuntu_check(osver: "6.06", pkgname: "mono-classlib-1.0", pkgver: "1.1.13.6-0ubuntu3.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package mono-classlib-1.0-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to mono-classlib-1.0-1.1.13.6-0ubuntu3.1
');
}
found = ubuntu_check(osver: "6.06", pkgname: "mono-classlib-1.0-dbg", pkgver: "1.1.13.6-0ubuntu3.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package mono-classlib-1.0-dbg-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to mono-classlib-1.0-dbg-1.1.13.6-0ubuntu3.1
');
}
found = ubuntu_check(osver: "6.06", pkgname: "mono-classlib-2.0", pkgver: "1.1.13.6-0ubuntu3.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package mono-classlib-2.0-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to mono-classlib-2.0-1.1.13.6-0ubuntu3.1
');
}
found = ubuntu_check(osver: "6.06", pkgname: "mono-classlib-2.0-dbg", pkgver: "1.1.13.6-0ubuntu3.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package mono-classlib-2.0-dbg-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to mono-classlib-2.0-dbg-1.1.13.6-0ubuntu3.1
');
}
found = ubuntu_check(osver: "6.06", pkgname: "mono-common", pkgver: "1.1.13.6-0ubuntu3.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package mono-common-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to mono-common-1.1.13.6-0ubuntu3.1
');
}
found = ubuntu_check(osver: "6.06", pkgname: "mono-devel", pkgver: "1.1.13.6-0ubuntu3.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package mono-devel-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to mono-devel-1.1.13.6-0ubuntu3.1
');
}
found = ubuntu_check(osver: "6.06", pkgname: "mono-gac", pkgver: "1.1.13.6-0ubuntu3.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package mono-gac-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to mono-gac-1.1.13.6-0ubuntu3.1
');
}
found = ubuntu_check(osver: "6.06", pkgname: "mono-gmcs", pkgver: "1.1.13.6-0ubuntu3.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package mono-gmcs-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to mono-gmcs-1.1.13.6-0ubuntu3.1
');
}
found = ubuntu_check(osver: "6.06", pkgname: "mono-jay", pkgver: "1.1.13.6-0ubuntu3.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package mono-jay-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to mono-jay-1.1.13.6-0ubuntu3.1
');
}
found = ubuntu_check(osver: "6.06", pkgname: "mono-jit", pkgver: "1.1.13.6-0ubuntu3.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package mono-jit-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to mono-jit-1.1.13.6-0ubuntu3.1
');
}
found = ubuntu_check(osver: "6.06", pkgname: "mono-mcs", pkgver: "1.1.13.6-0ubuntu3.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package mono-mcs-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to mono-mcs-1.1.13.6-0ubuntu3.1
');
}
found = ubuntu_check(osver: "6.06", pkgname: "mono-utils", pkgver: "1.1.13.6-0ubuntu3.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package mono-utils-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to mono-utils-1.1.13.6-0ubuntu3.1
');
}

if (w) { security_hole(port: 0, data: desc); }
