# This script was automatically generated from the 379-1 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

These remote packages are missing security patches :
- info 
- texinfo 


Description :

Miloslav Trmac discovered a buffer overflow in texinfo\'s index 
processor.  If a user is tricked into processing a .texi file with 
texindex, this could lead to arbitrary code execution with user 
privileges.

Solution :

Upgrade to : 
- info-4.8.dfsg.1-1ubuntu0.1 (Ubuntu 6.10)
- texinfo-4.8.dfsg.1-1ubuntu0.1 (Ubuntu 6.10)



Risk factor : High
';

if (description) {
script_id(27961);
script_version("$Revision: 1.1 $");
script_copyright("Ubuntu Security Notice (C) 2007 Canonical, Inc. / NASL script (C) 2007 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "379-1");
script_summary(english:"texinfo vulnerability");
script_name(english:"USN379-1 : texinfo vulnerability");
script_cve_id("CVE-2006-4810");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "6.10", pkgname: "info", pkgver: "4.8.dfsg.1-1ubuntu0.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package info-',found,' is vulnerable in Ubuntu 6.10
Upgrade it to info-4.8.dfsg.1-1ubuntu0.1
');
}
found = ubuntu_check(osver: "6.10", pkgname: "texinfo", pkgver: "4.8.dfsg.1-1ubuntu0.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package texinfo-',found,' is vulnerable in Ubuntu 6.10
Upgrade it to texinfo-4.8.dfsg.1-1ubuntu0.1
');
}

if (w) { security_hole(port: 0, data: desc); }
