# This script was automatically generated from the 394-1 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

These remote packages are missing security patches :
- irb1.8 
- libdbm-ruby1.8 
- libgdbm-ruby1.8 
- libopenssl-ruby1.8 
- libreadline-ruby1.8 
- libruby1.8 
- libruby1.8-dbg 
- libtcltk-ruby1.8 
- rdoc1.8 
- ri1.8 
- ruby1.8 
- ruby1.8-dev 
- ruby1.8-elisp 
- ruby1.8-examples 


Description :

An error was found in Ruby\'s CGI library that did not correctly quote 
the boundary of multipart MIME requests.  Using a crafted HTTP request, 
a remote user could cause a denial of service, where Ruby CGI 
applications would end up in a loop, monopolizing a CPU.

Solution :

Upgrade to : 
- irb1.8-1.8.4-5ubuntu1.2 (Ubuntu 6.10)
- libdbm-ruby1.8-1.8.4-5ubuntu1.2 (Ubuntu 6.10)
- libgdbm-ruby1.8-1.8.4-5ubuntu1.2 (Ubuntu 6.10)
- libopenssl-ruby1.8-1.8.4-5ubuntu1.2 (Ubuntu 6.10)
- libreadline-ruby1.8-1.8.4-5ubuntu1.2 (Ubuntu 6.10)
- libruby1.8-1.8.4-5ubuntu1.2 (Ubuntu 6.10)
- libruby1.8-dbg-1.8.4-5ubuntu1.2 (Ubuntu 6.10)
- libtcltk-ruby1.8-1.8.4-5ubuntu1.2 (Ubuntu 6.10)
- rdoc1.8-1.8.4-5ubuntu1.2 (Ubuntu 6.10)
- ri1.8-1.8.4-5ubuntu1.2 (Ubuntu 6.10)
- ruby1.8-1.8.4-5ubuntu1.2 (Ubunt
[...]


Risk factor : High
';

if (description) {
script_id(27980);
script_version("$Revision: 1.1 $");
script_copyright("Ubuntu Security Notice (C) 2007 Canonical, Inc. / NASL script (C) 2007 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "394-1");
script_summary(english:"Ruby vulnerability");
script_name(english:"USN394-1 : Ruby vulnerability");
script_cve_id("CVE-2006-6303");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "6.10", pkgname: "irb1.8", pkgver: "1.8.4-5ubuntu1.2");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package irb1.8-',found,' is vulnerable in Ubuntu 6.10
Upgrade it to irb1.8-1.8.4-5ubuntu1.2
');
}
found = ubuntu_check(osver: "6.10", pkgname: "libdbm-ruby1.8", pkgver: "1.8.4-5ubuntu1.2");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libdbm-ruby1.8-',found,' is vulnerable in Ubuntu 6.10
Upgrade it to libdbm-ruby1.8-1.8.4-5ubuntu1.2
');
}
found = ubuntu_check(osver: "6.10", pkgname: "libgdbm-ruby1.8", pkgver: "1.8.4-5ubuntu1.2");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libgdbm-ruby1.8-',found,' is vulnerable in Ubuntu 6.10
Upgrade it to libgdbm-ruby1.8-1.8.4-5ubuntu1.2
');
}
found = ubuntu_check(osver: "6.10", pkgname: "libopenssl-ruby1.8", pkgver: "1.8.4-5ubuntu1.2");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libopenssl-ruby1.8-',found,' is vulnerable in Ubuntu 6.10
Upgrade it to libopenssl-ruby1.8-1.8.4-5ubuntu1.2
');
}
found = ubuntu_check(osver: "6.10", pkgname: "libreadline-ruby1.8", pkgver: "1.8.4-5ubuntu1.2");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libreadline-ruby1.8-',found,' is vulnerable in Ubuntu 6.10
Upgrade it to libreadline-ruby1.8-1.8.4-5ubuntu1.2
');
}
found = ubuntu_check(osver: "6.10", pkgname: "libruby1.8", pkgver: "1.8.4-5ubuntu1.2");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libruby1.8-',found,' is vulnerable in Ubuntu 6.10
Upgrade it to libruby1.8-1.8.4-5ubuntu1.2
');
}
found = ubuntu_check(osver: "6.10", pkgname: "libruby1.8-dbg", pkgver: "1.8.4-5ubuntu1.2");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libruby1.8-dbg-',found,' is vulnerable in Ubuntu 6.10
Upgrade it to libruby1.8-dbg-1.8.4-5ubuntu1.2
');
}
found = ubuntu_check(osver: "6.10", pkgname: "libtcltk-ruby1.8", pkgver: "1.8.4-5ubuntu1.2");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libtcltk-ruby1.8-',found,' is vulnerable in Ubuntu 6.10
Upgrade it to libtcltk-ruby1.8-1.8.4-5ubuntu1.2
');
}
found = ubuntu_check(osver: "6.10", pkgname: "rdoc1.8", pkgver: "1.8.4-5ubuntu1.2");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package rdoc1.8-',found,' is vulnerable in Ubuntu 6.10
Upgrade it to rdoc1.8-1.8.4-5ubuntu1.2
');
}
found = ubuntu_check(osver: "6.10", pkgname: "ri1.8", pkgver: "1.8.4-5ubuntu1.2");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package ri1.8-',found,' is vulnerable in Ubuntu 6.10
Upgrade it to ri1.8-1.8.4-5ubuntu1.2
');
}
found = ubuntu_check(osver: "6.10", pkgname: "ruby1.8", pkgver: "1.8.4-5ubuntu1.2");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package ruby1.8-',found,' is vulnerable in Ubuntu 6.10
Upgrade it to ruby1.8-1.8.4-5ubuntu1.2
');
}
found = ubuntu_check(osver: "6.10", pkgname: "ruby1.8-dev", pkgver: "1.8.4-5ubuntu1.2");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package ruby1.8-dev-',found,' is vulnerable in Ubuntu 6.10
Upgrade it to ruby1.8-dev-1.8.4-5ubuntu1.2
');
}
found = ubuntu_check(osver: "6.10", pkgname: "ruby1.8-elisp", pkgver: "1.8.4-5ubuntu1.2");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package ruby1.8-elisp-',found,' is vulnerable in Ubuntu 6.10
Upgrade it to ruby1.8-elisp-1.8.4-5ubuntu1.2
');
}
found = ubuntu_check(osver: "6.10", pkgname: "ruby1.8-examples", pkgver: "1.8.4-5ubuntu1.2");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package ruby1.8-examples-',found,' is vulnerable in Ubuntu 6.10
Upgrade it to ruby1.8-examples-1.8.4-5ubuntu1.2
');
}

if (w) { security_hole(port: 0, data: desc); }
