# This script was automatically generated from the 398-4 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

These remote packages are missing security patches :
- firefox 
- firefox-dbg 
- firefox-dev 
- firefox-dom-inspector 
- firefox-gnome-support 
- libnspr-dev 
- libnspr4 
- libnss-dev 
- libnss3 
- mozilla-firefox 
- mozilla-firefox-dev 


Description :

USN-398-2 fixed vulnerabilities in Firefox 1.5.  However, when 
auto-filling saved-password login forms without a username field, 
Firefox would crash.  This update fixes the problem.

We apologize for the inconvenience.

Original advisory details:

 Various flaws have been reported that allow an attacker to execute
 arbitrary code with user privileges by tricking the user into opening
 a malicious web page containing JavaScript or SVG.  (CVE-2006-6497, 
 CVE-2006-6498, CVE-2006-6499, CVE-2006-6501, CVE-2006-6502, 
 CVE-2006-6504)

 Various flaws have been reported that allow an attacker to bypass 
 Firefox\'s internal XSS protections by tricking the user into opening a 
 malicious web page containing JavaScript.  (CVE-2006-6503)

Solution :

Upgrade to : 
- firefox-1.5.dfsg+1.5.0.9-0ubuntu0.6.06.1 (Ubuntu 6.06)
- firefox-dbg-1.5.dfsg+1.5.0.9-0ubuntu0.6.06.1 (Ubuntu 6.06)
- firefox-dev-1.5.dfsg+1.5.0.9-0ubuntu0.6.06.1 (Ubuntu 6.06)
- firefox-dom-inspector-1.5.dfsg+1.5.0.9-0ubuntu0.6.06.1 (Ubuntu 6.06)
- firefox-gnome-support-1.5.dfsg+1.5.0.9-0ubuntu0.6.06.1 (Ubuntu 6.06)
- libnspr-dev-1.firefox1.5.dfsg+1.5.0.9-0ubuntu0.6.06.1 (Ubuntu 6.06)
- libnspr4-1.firefox1.5.dfsg+1.5.0.9-0ubuntu0.6.06.1 (Ubuntu 6.06)
- libnss-dev-1.firefox1.5.dfsg+1.5.0.9-
[...]


Risk factor : High
';

if (description) {
script_id(27986);
script_version("$Revision: 1.1 $");
script_copyright("Ubuntu Security Notice (C) 2007 Canonical, Inc. / NASL script (C) 2007 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "398-4");
script_summary(english:"Firefox regression");
script_name(english:"USN398-4 : Firefox regression");
script_cve_id("CVE-2006-6497","CVE-2006-6498","CVE-2006-6499","CVE-2006-6501","CVE-2006-6502","CVE-2006-6503","CVE-2006-6504");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "6.06", pkgname: "firefox", pkgver: "1.5.dfsg+1.5.0.9-0ubuntu0.6.06.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package firefox-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to firefox-1.5.dfsg+1.5.0.9-0ubuntu0.6.06.1
');
}
found = ubuntu_check(osver: "6.06", pkgname: "firefox-dbg", pkgver: "1.5.dfsg+1.5.0.9-0ubuntu0.6.06.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package firefox-dbg-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to firefox-dbg-1.5.dfsg+1.5.0.9-0ubuntu0.6.06.1
');
}
found = ubuntu_check(osver: "6.06", pkgname: "firefox-dev", pkgver: "1.5.dfsg+1.5.0.9-0ubuntu0.6.06.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package firefox-dev-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to firefox-dev-1.5.dfsg+1.5.0.9-0ubuntu0.6.06.1
');
}
found = ubuntu_check(osver: "6.06", pkgname: "firefox-dom-inspector", pkgver: "1.5.dfsg+1.5.0.9-0ubuntu0.6.06.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package firefox-dom-inspector-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to firefox-dom-inspector-1.5.dfsg+1.5.0.9-0ubuntu0.6.06.1
');
}
found = ubuntu_check(osver: "6.06", pkgname: "firefox-gnome-support", pkgver: "1.5.dfsg+1.5.0.9-0ubuntu0.6.06.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package firefox-gnome-support-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to firefox-gnome-support-1.5.dfsg+1.5.0.9-0ubuntu0.6.06.1
');
}
found = ubuntu_check(osver: "6.06", pkgname: "libnspr-dev", pkgver: "1.firefox1.5.dfsg+1.5.0.9-0ubuntu0.6.06.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libnspr-dev-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to libnspr-dev-1.firefox1.5.dfsg+1.5.0.9-0ubuntu0.6.06.1
');
}
found = ubuntu_check(osver: "6.06", pkgname: "libnspr4", pkgver: "1.firefox1.5.dfsg+1.5.0.9-0ubuntu0.6.06.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libnspr4-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to libnspr4-1.firefox1.5.dfsg+1.5.0.9-0ubuntu0.6.06.1
');
}
found = ubuntu_check(osver: "6.06", pkgname: "libnss-dev", pkgver: "1.firefox1.5.dfsg+1.5.0.9-0ubuntu0.6.06.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libnss-dev-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to libnss-dev-1.firefox1.5.dfsg+1.5.0.9-0ubuntu0.6.06.1
');
}
found = ubuntu_check(osver: "6.06", pkgname: "libnss3", pkgver: "1.firefox1.5.dfsg+1.5.0.9-0ubuntu0.6.06.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libnss3-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to libnss3-1.firefox1.5.dfsg+1.5.0.9-0ubuntu0.6.06.1
');
}
found = ubuntu_check(osver: "6.06", pkgname: "mozilla-firefox", pkgver: "1.5.dfsg+1.5.0.9-0ubuntu0.6.06.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package mozilla-firefox-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to mozilla-firefox-1.5.dfsg+1.5.0.9-0ubuntu0.6.06.1
');
}
found = ubuntu_check(osver: "6.06", pkgname: "mozilla-firefox-dev", pkgver: "1.5.dfsg+1.5.0.9-0ubuntu0.6.06.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package mozilla-firefox-dev-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to mozilla-firefox-dev-1.5.dfsg+1.5.0.9-0ubuntu0.6.06.1
');
}

if (w) { security_hole(port: 0, data: desc); }
