# This script was automatically generated from the 425-1 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

The remote package "slocate" is missing a security patch.

Description :

A flaw was discovered in the permission checking code of slocate.  When 
reporting matching files, locate would not correctly respect the parent 
directory\'s "read" bits.  This could result in filenames being displayed 
when the file owner had expected them to remain hidden from other system 
users.

Solution :

Upgrade to : 
- slocate-3.1-1ubuntu0.1 (Ubuntu 6.10)



Risk factor : High
';

if (description) {
script_id(28018);
script_version("$Revision: 1.1 $");
script_copyright("Ubuntu Security Notice (C) 2007 Canonical, Inc. / NASL script (C) 2007 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "425-1");
script_summary(english:"slocate vulnerability");
script_name(english:"USN425-1 : slocate vulnerability");
script_cve_id("CVE-2007-0227");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "6.10", pkgname: "slocate", pkgver: "3.1-1ubuntu0.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package slocate-',found,' is vulnerable in Ubuntu 6.10
Upgrade it to slocate-3.1-1ubuntu0.1
');
}

if (w) { security_hole(port: 0, data: desc); }
