# This script was automatically generated from the 438-1 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

The remote package "inkscape" is missing a security patch.

Description :

A flaw was discovered in Inkscape\'s use of format strings.  If a user 
were tricked into opening a specially crafted URI in Inkscape, a remote 
attacker could execute arbitrary code with user privileges.

Solution :

Upgrade to : 
- inkscape-0.44-1ubuntu2.1 (Ubuntu 6.10)



Risk factor : High
';

if (description) {
script_id(28034);
script_version("$Revision: 1.1 $");
script_copyright("Ubuntu Security Notice (C) 2007 Canonical, Inc. / NASL script (C) 2007 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "438-1");
script_summary(english:"Inkscape vulnerability");
script_name(english:"USN438-1 : Inkscape vulnerability");
script_cve_id("CVE-2007-1463");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "6.10", pkgname: "inkscape", pkgver: "0.44-1ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package inkscape-',found,' is vulnerable in Ubuntu 6.10
Upgrade it to inkscape-0.44-1ubuntu2.1
');
}

if (w) { security_hole(port: 0, data: desc); }
