# This script was automatically generated from the 453-2 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

The remote package "rdesktop" is missing a security patch.

Description :

USN-453-1 provided an updated libx11 package to fix a security
vulnerability. This triggered an error in rdesktop so that it crashed
on startup. This update fixes the problem.

Solution :

Upgrade to : 
- rdesktop-1.4.1-1.1ubuntu0.6.10 (Ubuntu 6.10)



Risk factor : High
';

if (description) {
script_id(28051);
script_version("$Revision: 1.1 $");
script_copyright("Ubuntu Security Notice (C) 2007 Canonical, Inc. / NASL script (C) 2007 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "453-2");
script_summary(english:"rdesktop regression");
script_name(english:"USN453-2 : rdesktop regression");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "6.10", pkgname: "rdesktop", pkgver: "1.4.1-1.1ubuntu0.6.10");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package rdesktop-',found,' is vulnerable in Ubuntu 6.10
Upgrade it to rdesktop-1.4.1-1.1ubuntu0.6.10
');
}

if (w) { security_hole(port: 0, data: desc); }
