# This script was automatically generated from the 459-1 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

These remote packages are missing security patches :
- bcrelay 
- pptpd 


Description :

A flaw was discovered in the PPTP tunnel server. Remote attackers could 
send a specially crafted packet and disrupt established PPTP tunnels, 
leading to a denial of service.

Solution :

Upgrade to : 
- bcrelay-1.3.0-2ubuntu2.1 (Ubuntu 7.04)
- pptpd-1.3.0-2ubuntu2.1 (Ubuntu 7.04)



Risk factor : High
';

if (description) {
script_id(28057);
script_version("$Revision: 1.1 $");
script_copyright("Ubuntu Security Notice (C) 2007 Canonical, Inc. / NASL script (C) 2007 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "459-1");
script_summary(english:"pptpd vulnerability");
script_name(english:"USN459-1 : pptpd vulnerability");
script_cve_id("CVE-2007-0244");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "7.04", pkgname: "bcrelay", pkgver: "1.3.0-2ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package bcrelay-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to bcrelay-1.3.0-2ubuntu2.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "pptpd", pkgver: "1.3.0-2ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package pptpd-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to pptpd-1.3.0-2ubuntu2.1
');
}

if (w) { security_hole(port: 0, data: desc); }
