# This script was automatically generated from the 481-1 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

These remote packages are missing security patches :
- imagemagick 
- libmagick++9-dev 
- libmagick++9c2a 
- libmagick9 
- libmagick9-dev 
- perlmagick 


Description :

Multiple vulnerabilities were found in ImageMagick\'s handling of DCM and
WXD image files.  By tricking a user into processing a specially crafted
image with an application that uses imagemagick, an attacker could
execute arbitrary code with the user\'s privileges.

Solution :

Upgrade to : 
- imagemagick-6.2.4.5.dfsg1-0.14ubuntu0.1 (Ubuntu 7.04)
- libmagick++9-dev-6.2.4.5.dfsg1-0.14ubuntu0.1 (Ubuntu 7.04)
- libmagick++9c2a-6.2.4.5.dfsg1-0.14ubuntu0.1 (Ubuntu 7.04)
- libmagick9-6.2.4.5.dfsg1-0.14ubuntu0.1 (Ubuntu 7.04)
- libmagick9-dev-6.2.4.5.dfsg1-0.14ubuntu0.1 (Ubuntu 7.04)
- perlmagick-6.2.4.5.dfsg1-0.14ubuntu0.1 (Ubuntu 7.04)



Risk factor : High
';

if (description) {
script_id(28082);
script_version("$Revision: 1.1 $");
script_copyright("Ubuntu Security Notice (C) 2007 Canonical, Inc. / NASL script (C) 2007 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "481-1");
script_summary(english:"ImageMagick vulnerabilities");
script_name(english:"USN481-1 : ImageMagick vulnerabilities");
script_cve_id("CVE-2007-1667","CVE-2007-1797");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "7.04", pkgname: "imagemagick", pkgver: "6.2.4.5.dfsg1-0.14ubuntu0.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package imagemagick-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to imagemagick-6.2.4.5.dfsg1-0.14ubuntu0.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "libmagick++9-dev", pkgver: "6.2.4.5.dfsg1-0.14ubuntu0.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libmagick++9-dev-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to libmagick++9-dev-6.2.4.5.dfsg1-0.14ubuntu0.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "libmagick++9c2a", pkgver: "6.2.4.5.dfsg1-0.14ubuntu0.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libmagick++9c2a-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to libmagick++9c2a-6.2.4.5.dfsg1-0.14ubuntu0.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "libmagick9", pkgver: "6.2.4.5.dfsg1-0.14ubuntu0.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libmagick9-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to libmagick9-6.2.4.5.dfsg1-0.14ubuntu0.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "libmagick9-dev", pkgver: "6.2.4.5.dfsg1-0.14ubuntu0.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libmagick9-dev-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to libmagick9-dev-6.2.4.5.dfsg1-0.14ubuntu0.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "perlmagick", pkgver: "6.2.4.5.dfsg1-0.14ubuntu0.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package perlmagick-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to perlmagick-6.2.4.5.dfsg1-0.14ubuntu0.1
');
}

if (w) { security_hole(port: 0, data: desc); }
