# This script was automatically generated from the 488-1 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

These remote packages are missing security patches :
- libapache2-mod-perl2 
- libapache2-mod-perl2-dev 
- libapache2-mod-perl2-doc 


Description :

Alex Solovey discovered that mod_perl did not correctly validate certain
regular expression matches.  A remote attacker could send a specially
crafted request to a web application using mod_perl, causing the web
server to monopolize CPU resources.  This could lead to a remote denial
of service.

Solution :

Upgrade to : 
- libapache2-mod-perl2-2.0.2-2.3ubuntu1 (Ubuntu 7.04)
- libapache2-mod-perl2-dev-2.0.2-2.3ubuntu1 (Ubuntu 7.04)
- libapache2-mod-perl2-doc-2.0.2-2.3ubuntu1 (Ubuntu 7.04)



Risk factor : High
';

if (description) {
script_id(28089);
script_version("$Revision: 1.1 $");
script_copyright("Ubuntu Security Notice (C) 2007 Canonical, Inc. / NASL script (C) 2007 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "488-1");
script_summary(english:"mod_perl vulnerability");
script_name(english:"USN488-1 : mod_perl vulnerability");
script_cve_id("CVE-2007-1349");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "7.04", pkgname: "libapache2-mod-perl2", pkgver: "2.0.2-2.3ubuntu1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libapache2-mod-perl2-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to libapache2-mod-perl2-2.0.2-2.3ubuntu1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "libapache2-mod-perl2-dev", pkgver: "2.0.2-2.3ubuntu1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libapache2-mod-perl2-dev-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to libapache2-mod-perl2-dev-2.0.2-2.3ubuntu1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "libapache2-mod-perl2-doc", pkgver: "2.0.2-2.3ubuntu1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libapache2-mod-perl2-doc-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to libapache2-mod-perl2-doc-2.0.2-2.3ubuntu1
');
}

if (w) { security_hole(port: 0, data: desc); }
