# This script was automatically generated from the 506-1 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

The remote package "tar" is missing a security patch.

Description :

Dmitry V. Levin discovered that tar did not correctly detect the ".."
file path element when unpacking archives.  If a user or an automated
system were tricked into unpacking a specially crafted tar file, arbitrary
files could be overwritten with user privileges.

Solution :

Upgrade to : 
- tar-1.16-2ubuntu0.1 (Ubuntu 7.04)



Risk factor : High
';

if (description) {
script_id(28110);
script_version("$Revision: 1.1 $");
script_copyright("Ubuntu Security Notice (C) 2007 Canonical, Inc. / NASL script (C) 2007 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "506-1");
script_summary(english:"tar vulnerability");
script_name(english:"USN506-1 : tar vulnerability");
script_cve_id("CVE-2007-4131");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "7.04", pkgname: "tar", pkgver: "1.16-2ubuntu0.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package tar-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to tar-1.16-2ubuntu0.1
');
}

if (w) { security_hole(port: 0, data: desc); }
