# This script was automatically generated from the 507-1 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

These remote packages are missing security patches :
- libwrap0 
- libwrap0-dev 
- tcpd 


Description :

It was discovered that the TCP wrapper library was incorrectly allowing
connections to services that did not specify server-side connection
details.  Remote attackers could connect to services that had been
configured to block such connections.  This only affected Ubuntu Feisty.

Solution :

Upgrade to : 
- libwrap0-7.6.dbs-11ubuntu0.1 (Ubuntu 7.04)
- libwrap0-dev-7.6.dbs-11ubuntu0.1 (Ubuntu 7.04)
- tcpd-7.6.dbs-11ubuntu0.1 (Ubuntu 7.04)



Risk factor : High
';

if (description) {
script_id(28111);
script_version("$Revision: 1.1 $");
script_copyright("Ubuntu Security Notice (C) 2007 Canonical, Inc. / NASL script (C) 2007 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "507-1");
script_summary(english:"tcp-wrappers vulnerability");
script_name(english:"USN507-1 : tcp-wrappers vulnerability");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "7.04", pkgname: "libwrap0", pkgver: "7.6.dbs-11ubuntu0.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libwrap0-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to libwrap0-7.6.dbs-11ubuntu0.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "libwrap0-dev", pkgver: "7.6.dbs-11ubuntu0.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libwrap0-dev-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to libwrap0-dev-7.6.dbs-11ubuntu0.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "tcpd", pkgver: "7.6.dbs-11ubuntu0.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package tcpd-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to tcpd-7.6.dbs-11ubuntu0.1
');
}

if (w) { security_hole(port: 0, data: desc); }
