# This script was automatically generated from the 514-1 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

These remote packages are missing security patches :
- xdmx 
- xdmx-tools 
- xnest 
- xserver-xorg-core 
- xserver-xorg-dev 
- xvfb 


Description :

Aaron Plattner discovered that the Composite extension did not correctly
calculate the size of buffers when copying between different bit depths.
An authenticated user could exploit this to execute arbitrary code with
root privileges.

Solution :

Upgrade to : 
- xdmx-1.0.2-0ubuntu10.7 (Ubuntu 6.06)
- xdmx-tools-1.0.2-0ubuntu10.7 (Ubuntu 6.06)
- xnest-1.0.2-0ubuntu10.7 (Ubuntu 6.06)
- xserver-xorg-core-1.0.2-0ubuntu10.7 (Ubuntu 6.06)
- xserver-xorg-dev-1.0.2-0ubuntu10.7 (Ubuntu 6.06)
- xvfb-1.0.2-0ubuntu10.7 (Ubuntu 6.06)



Risk factor : High
';

if (description) {
script_id(28119);
script_version("$Revision: 1.1 $");
script_copyright("Ubuntu Security Notice (C) 2007 Canonical, Inc. / NASL script (C) 2007 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "514-1");
script_summary(english:"X.org vulnerability");
script_name(english:"USN514-1 : X.org vulnerability");
script_cve_id("CVE-2007-4730");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "6.06", pkgname: "xdmx", pkgver: "1.0.2-0ubuntu10.7");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package xdmx-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to xdmx-1.0.2-0ubuntu10.7
');
}
found = ubuntu_check(osver: "6.06", pkgname: "xdmx-tools", pkgver: "1.0.2-0ubuntu10.7");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package xdmx-tools-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to xdmx-tools-1.0.2-0ubuntu10.7
');
}
found = ubuntu_check(osver: "6.06", pkgname: "xnest", pkgver: "1.0.2-0ubuntu10.7");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package xnest-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to xnest-1.0.2-0ubuntu10.7
');
}
found = ubuntu_check(osver: "6.06", pkgname: "xserver-xorg-core", pkgver: "1.0.2-0ubuntu10.7");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package xserver-xorg-core-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to xserver-xorg-core-1.0.2-0ubuntu10.7
');
}
found = ubuntu_check(osver: "6.06", pkgname: "xserver-xorg-dev", pkgver: "1.0.2-0ubuntu10.7");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package xserver-xorg-dev-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to xserver-xorg-dev-1.0.2-0ubuntu10.7
');
}
found = ubuntu_check(osver: "6.06", pkgname: "xvfb", pkgver: "1.0.2-0ubuntu10.7");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package xvfb-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to xvfb-1.0.2-0ubuntu10.7
');
}

if (w) { security_hole(port: 0, data: desc); }
