# This script was automatically generated from the 525-1 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

These remote packages are missing security patches :
- libsndfile1 
- libsndfile1-dev 
- sndfile-programs 


Description :

Robert Buchholz discovered that libsndfile did not correctly validate the
size of its memory buffers.  If a user were tricked into playing a specially
crafted FLAC file, a remote attacker could execute arbitrary code with user
privileges.

Solution :

Upgrade to : 
- libsndfile1-1.0.16-1ubuntu0.7.04.1 (Ubuntu 7.04)
- libsndfile1-dev-1.0.16-1ubuntu0.7.04.1 (Ubuntu 7.04)
- sndfile-programs-1.0.16-1ubuntu0.7.04.1 (Ubuntu 7.04)



Risk factor : High
';

if (description) {
script_id(28130);
script_version("$Revision: 1.1 $");
script_copyright("Ubuntu Security Notice (C) 2007 Canonical, Inc. / NASL script (C) 2007 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "525-1");
script_summary(english:"libsndfile vulnerability");
script_name(english:"USN525-1 : libsndfile vulnerability");
script_cve_id("CVE-2007-4974");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "7.04", pkgname: "libsndfile1", pkgver: "1.0.16-1ubuntu0.7.04.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libsndfile1-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to libsndfile1-1.0.16-1ubuntu0.7.04.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "libsndfile1-dev", pkgver: "1.0.16-1ubuntu0.7.04.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libsndfile1-dev-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to libsndfile1-dev-1.0.16-1ubuntu0.7.04.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "sndfile-programs", pkgver: "1.0.16-1ubuntu0.7.04.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package sndfile-programs-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to sndfile-programs-1.0.16-1ubuntu0.7.04.1
');
}

if (w) { security_hole(port: 0, data: desc); }
