# This script was automatically generated from the 526-1 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

The remote package "debian-goodies" is missing a security patch.

Description :

Thomas de Grenier de Latour discovered that the checkrestart program included
in debian-goodies did not correctly handle shell meta-characters.  A local
attacker could exploit this to gain the privileges of the user running
checkrestart.

Solution :

Upgrade to : 
- debian-goodies-0.27ubuntu0.1 (Ubuntu 7.04)



Risk factor : High
';

if (description) {
script_id(28131);
script_version("$Revision: 1.1 $");
script_copyright("Ubuntu Security Notice (C) 2007 Canonical, Inc. / NASL script (C) 2007 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "526-1");
script_summary(english:"debian-goodies vulnerability");
script_name(english:"USN526-1 : debian-goodies vulnerability");
script_cve_id("CVE-2007-3912");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "7.04", pkgname: "debian-goodies", pkgver: "0.27ubuntu0.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package debian-goodies-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to debian-goodies-0.27ubuntu0.1
');
}

if (w) { security_hole(port: 0, data: desc); }
