# This script was automatically generated from the 531-2 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

These remote packages are missing security patches :
- dhcp 
- dhcp-client 
- dhcp-relay 


Description :

USN-531-1 fixed vulnerabilities in dhcp.  The fixes were incomplete,
and only reduced the scope of the vulnerability, without fully solving
it. This update fixes the problem.

Original advisory details:

 Nahuel Riva and Gerardo Richarte discovered that the DHCP server did not
 correctly handle certain client options. A remote attacker could send
 malicious DHCP replies to the server and execute arbitrary code.

Solution :

Upgrade to : 
- dhcp-2.0pl5dfsg1-20ubuntu1.2 (Ubuntu 7.10)
- dhcp-client-2.0pl5dfsg1-20ubuntu1.2 (Ubuntu 7.10)
- dhcp-relay-2.0pl5dfsg1-20ubuntu1.2 (Ubuntu 7.10)



Risk factor : High
';

if (description) {
script_id(28137);
script_version("$Revision: 1.1 $");
script_copyright("Ubuntu Security Notice (C) 2007 Canonical, Inc. / NASL script (C) 2007 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "531-2");
script_summary(english:"dhcp vulnerability");
script_name(english:"USN531-2 : dhcp vulnerability");
script_cve_id("CVE-2007-5365");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "7.10", pkgname: "dhcp", pkgver: "2.0pl5dfsg1-20ubuntu1.2");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package dhcp-',found,' is vulnerable in Ubuntu 7.10
Upgrade it to dhcp-2.0pl5dfsg1-20ubuntu1.2
');
}
found = ubuntu_check(osver: "7.10", pkgname: "dhcp-client", pkgver: "2.0pl5dfsg1-20ubuntu1.2");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package dhcp-client-',found,' is vulnerable in Ubuntu 7.10
Upgrade it to dhcp-client-2.0pl5dfsg1-20ubuntu1.2
');
}
found = ubuntu_check(osver: "7.10", pkgname: "dhcp-relay", pkgver: "2.0pl5dfsg1-20ubuntu1.2");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package dhcp-relay-',found,' is vulnerable in Ubuntu 7.10
Upgrade it to dhcp-relay-2.0pl5dfsg1-20ubuntu1.2
');
}

if (w) { security_hole(port: 0, data: desc); }
