# This script was automatically generated from the 532-1 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

These remote packages are missing security patches :
- nagios-plugins 
- nagios-plugins-basic 
- nagios-plugins-standard 


Description :

Nobuhiro Ban discovered that check_http in nagios-plugins did
not properly sanitize its input when following redirection
requests. A malicious remote web server could cause a denial
of service or possibly execute arbitrary code as the user.
(CVE-2007-5198)

Aravind Gottipati discovered that sslutils.c in nagios-plugins
did not properly reset pointers to NULL. A malicious remote web
server could cause a denial of service.

Aravind Gottipati discovered that check_http in nagios-plugins
did not properly calculate how much memory to reallocate when
following redirection requests. A malicious remote web server
could cause a denial of service.

Solution :

Upgrade to : 
- nagios-plugins-1.4.2-5ubuntu3.1 (Ubuntu 6.06)
- nagios-plugins-basic-1.4.2-5ubuntu3.1 (Ubuntu 6.06)
- nagios-plugins-standard-1.4.2-5ubuntu3.1 (Ubuntu 6.06)



Risk factor : High
';

if (description) {
script_id(28138);
script_version("$Revision: 1.1 $");
script_copyright("Ubuntu Security Notice (C) 2007 Canonical, Inc. / NASL script (C) 2007 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "532-1");
script_summary(english:"nagios-plugins vulnerability");
script_name(english:"USN532-1 : nagios-plugins vulnerability");
script_cve_id("CVE-2007-5198");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "6.06", pkgname: "nagios-plugins", pkgver: "1.4.2-5ubuntu3.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package nagios-plugins-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to nagios-plugins-1.4.2-5ubuntu3.1
');
}
found = ubuntu_check(osver: "6.06", pkgname: "nagios-plugins-basic", pkgver: "1.4.2-5ubuntu3.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package nagios-plugins-basic-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to nagios-plugins-basic-1.4.2-5ubuntu3.1
');
}
found = ubuntu_check(osver: "6.06", pkgname: "nagios-plugins-standard", pkgver: "1.4.2-5ubuntu3.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package nagios-plugins-standard-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to nagios-plugins-standard-1.4.2-5ubuntu3.1
');
}

if (w) { security_hole(port: 0, data: desc); }
