# This script was automatically generated from the 572-1 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

The remote package "apt-listchanges" is missing a security patch.

Description :

Felipe Sateler discovered that apt-listchanges did not use safe paths when
importing additional Python libraries.  A local attacker could exploit
this and execute arbitrary commands as the user running apt-listchanges.

Solution :

Upgrade to : 
- apt-listchanges-2.74ubuntu3.1 (Ubuntu 7.10)



Risk factor : High
';

if (description) {
script_id(30043);
script_version("$Revision: 1.1 $");
script_copyright("Ubuntu Security Notice (C) 2008 Canonical, Inc. / NASL script (C) 2007 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "572-1");
script_summary(english:"apt-listchanges vulnerability");
script_name(english:"USN572-1 : apt-listchanges vulnerability");
script_cve_id("CVE-2008-0302");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "7.10", pkgname: "apt-listchanges", pkgver: "2.74ubuntu3.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package apt-listchanges-',found,' is vulnerable in Ubuntu 7.10
Upgrade it to apt-listchanges-2.74ubuntu3.1
');
}

if (w) { security_hole(port: 0, data: desc); }
