#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(25345);
  script_version("$Revision: 1.6 $");

  script_cve_id("CVE-2007-3170", "CVE-2007-3171", "CVE-2007-3172");
  script_bugtraq_id(24210);

  script_name(english:"UebiMiau selected_theme Multiple Vulnerabilities");
  script_summary(english:"Checks for an XSS flaw in UebiMiau");

  desc = "
Synopsis :

The remote web server contains a PHP script that is susceptible to
multiple attacks. 

Description :

The remote host is running UebiMiau, a webmail application written in
PHP. 

The version of UebiMiau installed on the remote host fails to sanitize
user input to the 'selected_theme' parameter of the 'error.php' script
before using it as a template to generate dynamic HTML.  An
unauthenticated attacker may be able to leverage this issue to
disclose information about files or directories or to launch a cross-
site script attack against the affected application. 

See also :

http://archives.neohapsis.com/archives/fulldisclosure/2007-05/0511.html

Solution :

Unknown at this time.

Risk factor :

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:P/I:N/A:N)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl", "cross_site_scripting.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");
include("url_func.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);
if (get_kb_item("www/"+port+"/generic_xss")) exit(0);


# A simple alert.
xss = raw_string("<script>alert(", SCRIPT_NAME, ")</script>");
exss = urlencode(str:xss);


# Loop through various directories.
if (thorough_tests) dirs = make_list("/webmail", "/uebimiau", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  # Try to exploit the issue.
  req = http_get(
    item:string(
      dir, "/error.php?",
      "selected_theme=", exss
    ), 
    port:port
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if we see our exploit.
  if (string('unable to read template resource: "', xss, "/error.htm") >< res)
  {
    security_warning(port);
    exit(0);
  }
}
