#
# (C) Tenable Network Security
#


if (description)
{
  script_id(23651);
  script_version("$Revision: 1.5 $");

  script_cve_id("CVE-2006-5819");
  script_bugtraq_id(21120);
  script_xref(name:"OSVDB", value:"30286");
  script_xref(name:"OSVDB", value:"30287");
  script_xref(name:"OSVDB", value:"30288");

  script_name(english:"Ultraseek < 5.7 Multiple Vulnerabilities");
  script_summary(english:"Checks for Ultraseek < 5.7");

  desc = "
Synopsis :

The remote web server is affected by multiple issues. 

Description :

The remote host is running Ultraseek, an enterprise web search engine. 

According to the version in its banner, an unauthenticated remote
attacker reportedly can use '/highlight/index.html' script on the
remote install of Ultraseek as a proxy to launch web attacks or even
enumerate internal addresses and ports. 

In addition, the remote software also suffers from numerous
information disclosure vulnerabilities through other scripts. 

See also :

http://www.zerodayinitiative.com/advisories/ZDI-06-042.html
http://www.securityfocus.com/archive/1/451847/30/0/threaded
http://www.ultraseek.com/support/docs/RELNOTES.txt

Solution :

Upgrade to Ultraseek 5.7 or later.

Risk factor :

Critical / CVSS Base Score : 10.0
(CVSS2#AV:N/AC:L/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);

  script_category(ACT_GATHER_INFO);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2006-2007 Tenable Network Security");

  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 8765);

  exit(0);
}


include("http_func.inc");


port = get_http_port(default:8765);
if (!get_port_state(port)) exit(0);


# Check the version in the banner.
banner = get_http_banner(port:port);
if (
  banner &&
  "Server: Ultraseek" >< banner &&
  egrep(pattern:"^Server: Ultraseek/([0-4]\.|5\.[0-6]\.)", string:banner)
) security_hole(port);
