#
# This script was written by Michel Arboi <mikhail@nessus.org>
#
# It is released under the GNU Public Licence
#
# MA 2007-07-27: three new plugins have been released. They now use a random IV

if(description)
{
 script_id(19289);
 script_version ("$Revision: 1.7 $");
 
 script_name(english: "UltraVNC w/ DSM plugin detection");
 
 desc = "
Synopsis :

A remote control service is running on this port.

Description :

UltraVNC seems to be running on the remote port.

Upon connection, the remote service on this port always sends
the same 12 pseudo-random bytes.

It is probably UltraVNC with the old DSM encryption plugin.
This plugin tunnels the RFB protocol into a RC4 encrypted 
stream.
This old protocol does not use a random IV, so the RC4 pseudo
random flow is reused from one session to another. 
An authenticated user could decrypt other users' sessions.

Solution :

If this service is not needed, disable it or filter incoming traffic
to this port.
Otherwise, you should upgrade UltraVNC and use one of the new & safer
plugins, which now implement a random IV.

Risk factor : 

Low / CVSS Base Score : 2
(AV:R/AC:L/Au:R/C:C/I:N/A:N/B:N)";


 script_description(english:desc);
 
 script_summary(english: "Detect 12 pseudo-random bytes in banner (UltraVNC w/ old DSM)");
 
 script_category(ACT_GATHER_INFO); 
 script_copyright(english:"This script is Copyright (C) 2005 Michel Arboi");
 script_family(english: "Service detection");
 script_dependencie("find_service1.nasl", "vnc.nasl");
 script_require_ports("Services/unknown", 5900);
 exit(0);
}

#
include("misc_func.inc");
include("global_settings.inc");
include("dump.inc");

if ( thorough_tests && ! get_kb_item("global_settings/disable_service_discovery") )
{
 port = get_unknown_svc(5900);
 if (! port) exit(0);
}
else port = 5900;

if (! get_port_state(port)) exit(0);
if (! service_is_unknown(port: port)) exit(0);

b = get_kb_item('FindService/tcp/'+port+'/spontaneous');
if (strlen(b) != 12) exit(0);

s = open_sock_tcp(port);
if (! s) exit(0);

r1 = recv(socket: s, length: 512);
if (strlen(r1) != 12) exit(0);

send(socket: s, data: '012345678901');
r = recv(socket: s, length: 512);

# Let this test here: clear text VNC answers to my silly "request"
if (strlen(r) > 0) exit(0);

close(s);

s = open_sock_tcp(port);
if (! s) exit(0);

r2 = recv(socket: s, length: 512);
if (r2 != r1) exit(0);

close(s);

# I'm not sure about that and I don't have an old version of the plugin
# if (strlen(r) == 0) exit(0);

# aka statistical test, because I'm paranoid

total = 0;
all_ascii = TRUE;

for (i = 0; i < 12; i ++)
{
# z = ord(r[i]);
 z = ord(r1[i]);
 if (z < 9 || z > 126) all_ascii = 0;

 for (j = 1; j < 256; j *= 2)
  if (z & j) total ++;
}

if (all_ascii && report_paranoia < 1) exit(0);

if (total >= 24 && total <= 72)
{
 security_note(port: port);
 register_service(port: port, proto: 'ultravnc-dsm');
}
