#
# (C) Tenable Network Security
#

desc = "
Synopsis :

Arbitrary code can be executed on the remote host.

Description :

The remote host is running a version of Symantec Storage Foundation for
Windows which is vulnerable to a remote scheduler service access.  An 
attacker may exploit this flaw to modify or create scheduled commands
and gain a full access to the system. 

To exploit this flaw, an attacker would need to send requests to the
TCP service listening on port 4888.

Solution :

http://www.symantec.com/avcenter/security/Content/2007.06.01.html

Risk factor :

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";


if(description)
{
 script_id(25420);
 script_version("$Revision: 1.2 $");
 script_cve_id("CVE-2007-2279");
 script_bugtraq_id(24194);


 name["english"] = "Symantec Storage Foundation VxSchedService.EXE Scheduler Service Authentication Bypass Vulnerability";

 script_name(english:name["english"]);
 
 script_description(english:desc);
 
 summary["english"] = "Test the VERITAS Storage Foundation Scheduler Service Access";

 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "Gain root remotely";
 script_family(english:family["english"]);
 
 script_require_ports(4888);
 exit(0);
}



include ("byte_func.inc");

port = 4888;

if (!get_port_state(port))
  exit(0);

soc = open_sock_tcp(port);
if (!soc)
  exit(0);

req = 
	'<?xml version="1.0"?>\r\n' +
	'<Schedule>\r\n' +
	'<AppName>toto</AppName>\r\n' +
	'<ObjID>{c15f4527-3d6c-167b-f9c2-ca3908613b5a}</ObjID>\r\n' +
	'<TaskOpcode>0</TaskOpcode>\r\n' +
	'<Wrapper></Wrapper>\r\n' +
	'<XMLFilePath></XMLFilePath>\r\n' +
	'<Parameters></Parameters>\r\n' +
	'<PreScript></PreScript>\r\n' +
	'<PostScript></PostScript>\r\n' +
	'<UseGuid>0</UseGuid>\r\n' +
	'</Schedule>\r\n';

len = strlen(req);

data = 
	mkdword(len) +
	mkdword(2) +  # code(delete)
	mkdword(0x41414141) +
        "{c15f4527-3d6c-167b-f9c2-ca3908613b5a}" +
	mkbyte(0) +
	req;


send(socket:soc, data:data);
buf = recv(socket:soc, length:4096);


if ("{C15F4527-3D6C-167B-F9C2-CA3908613B5A}" >< buf && "-2147220979" >< buf)
  security_hole(port);
