#
#  (C) Tenable Network Security, Inc.
#


 desc = "
Synopsis :

The remote Windows host has an application that is affected by
multiple issues. 

Description :

The version of VMware Workstation installed on the remote host is
earlier than 5.5.4, Build 44386.  Such versions are reportedly
affected by several issues, including a directory traversal issue in
the application's Shared Folders feature that may allow read or write
access from a guest to a host system, subject to the privileges of the
user running VMware Workstation. 

See also :

http://labs.idefense.com/intelligence/vulnerabilities/display.php?id=521
http://archives.neohapsis.com/archives/bugtraq/2007-04/0487.html
http://www.vmware.com/support/ws55/doc/releasenotes_ws55.html

Solution :

Upgrade to VMware Workstation 5.5.4, Build 44386 or later. 

Risk factor : 

High / CVSS Base Score : 7.8
(CVSS2#AV:N/AC:L/Au:N/C:N/I:N/A:C)";


if (description)
{
  script_id(25119);
  script_version("$Revision: 1.9 $");

  script_cve_id("CVE-2007-1069", "CVE-2007-1337", "CVE-2007-1744", "CVE-2007-1876", "CVE-2007-1877");
  script_bugtraq_id(23721, 23732);

  script_name(english:"VMware Workstation < 5.5.4 Build 44386 Multiple Vulnerabilities");
  script_summary(english:"Checks version of VMware Workstation"); 
 
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("vmware_workstation_detect.nasl");
  script_require_keys("VMware/Workstation/Version");
  script_require_ports(139, 445);

  exit(0);
}

version = get_kb_item("VMware/Workstation/Version");
if (!version)
  exit (0);

v = split(version, sep:".", keep:FALSE);

 if ( ( int(v[0]) < 5 ) ||
     ( int(v[0]) == 5 && int(v[1]) < 5 ) ||
     ( int(v[0]) == 5 && int(v[1]) == 5 && int(v[2]) < 4 ) ||
     ( int(v[0]) == 5 && int(v[1]) == 5 && int(v[2]) == 4 && int(v[3]) < 44386 ) )
     {
   	security_hole(port);
	exit(0);
     }

