#
# (C) Tenable Network Security
#


if (description)
{
  script_id(24780);
  script_version("$Revision: 1.4 $");

  script_cve_id("CVE-2007-1343");
  script_bugtraq_id(22834);
  script_xref(name:"OSVDB", value:"33867");

  script_name(english:"WebCalendar noSet Variable Overwrite Vulnerability");
  script_summary(english:"Tries to overwrite variable in noSet array");

  desc = "
Synopsis :

The remote web server contains a PHP script that is affected by a
variable overwriting vulnerability. 

Description :

The version of WebCalendar installed on the remote host allows an
attacker to overwrite the 'noSet' array used by the application to
protect selected global variables.  By leveraging this issue, an
unauthenticated remote attacker can gain control of protected global
variables, which may lead to other attacks, such as remote file
includes. 

Note that successful exploitation of this issue does not require any
special PHP settings. 

See also :

http://sourceforge.net/project/shownotes.php?release_id=491130

Solution :

Upgrade to WebCalendar 1.0.5 or later. 

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security");

  script_dependencies("webcalendar_detect.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Test an install.
install = get_kb_item(string("www/", port, "/webcalendar"));
if (isnull(install)) exit(0);
matches = eregmatch(string:install, pattern:"^(.+) under (/.*)$");
if (!isnull(matches))
{
  dir = matches[2];

  # Try to generate an error by overwriting 'db_type'.
  req = http_get(
    item:string(
      dir, "/week.php?",
      "noSet[]=1&",
      "db_type=", SCRIPT_NAME
    ), 
    port:port
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if we could.
  if (string("dbi_connect(): invalid db_type '", SCRIPT_NAME, "'") >< res)
  {
    security_hole(port);
    exit(0);
  }
}
