#
# (C) Tenable Network Security, Inc.
#

 desc["english"] = "
Synopsis :

Several directories on the remote host are DAV-enabled.

Description :

WebDAV is an industry standard extension to the HTTP specification.
It adds a capability for authorized users to remotely add and manage
the content of a web server.

If you do not use this extension, you should disable it.

Solution :

Disable DAV support if you do not use it.

Risk factor :

None";

if(description)
{
  script_id(24004);
  script_version ("$Revision: 1.2 $");
  name["english"] = "WebDAV Directories Enumeration";
  script_name(english:name["english"]);
 script_description(english:desc["english"]);

 summary["english"] = "Determines which directories are DAV enabled";
 script_summary(english:summary["english"]);
 script_category(ACT_GATHER_INFO);

 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

 family["english"] = "Web Servers";

 script_family(english:family["english"]);

 script_dependencie("webmirror.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);
if ( ! port || ! get_port_state(port) ) exit(0);


dirs = get_kb_list(string("www/", port, "/content/directories"));
if ( isnull(dirs) ) exit(0);
dirs = make_list(dirs);

list = NULL;
failure = 0;

foreach dir ( dirs )
{ 
 if ( dir[0] == '/' )
 {
 if ( strlen(dir) > 0 && dir[strlen(dir) - 1] != '/' )
	dir += '/';
 req = http_get(item:dir, port:port);
 if (! req ) exit(0);
 req = str_replace(find:"GET ", replace:"OPTIONS ", string:req);
 res = http_keepalive_send_recv(port:port, data:req);
 if ( ! res ) break;
 if ( egrep(pattern:"^DAV: ", string:res) )
  {
   list += ' - ' + dir + '\n';
   set_kb_item(name:"www/" + port + "/webdav/directories", value:dir);
  }
  else failure ++;
 }
}
 
  

#
# Do not display a message if every dir has webdav enabled, as it will
# show up in webdav_detect.nasl
# 
if ( failure && strlen(list) )
{
  report = desc["english"] + '\n\nPlugin output :\n\n' +
 	   'The following directories are DAV enabled :\n' + list; 
  security_note(port:port, data:report);
}
