#
# (C) Tenable Network Security, Inc.
#


  desc = "
Synopsis :

The remote web server is susceptible to a buffer overflow attack. 

Description :

The remote host is running SAP DB or MaxDB, a SAP-certified open-
source database supporting OLTP and OLAP. 

According to its version, the Web DBM component of SAP DB or MaxDB on
the remote host reportedly contains a stack-based buffer overflow
triggered when displaying user-supplied arguments as part of the
'DBM_INTERN_TEST' event.  By sending an HTTP request with an argument
- a cookie for example - exceeding 10,000 bytes, an unauthenticated
remote attacker can leverage this issue to execute arbitrary code on
the affected host subject to the privileges of the 'wahttp' process. 

Note that on Windows the 'wahttp' process runs with 'SYSTEM'
privileges so a successful attack may result in a complete compromise
of the affected system. 

See also :

http://www.securityfocus.com/archive/1/472891/30/0/threaded
http://dev.mysql.com/doc/maxdb/changes/changes_7.5.00.44.html#Web_DBM
http://dev.mysql.com/doc/maxdb/changes/changes_7.6.00.37.html#Web_DBM

Solution :

Upgrade to MaxDB version 7.5.00.44 / 7.6.00.37 or later. 

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";


if (description)
{
  script_id(25681);
  script_version("$Revision: 1.4 $");

  script_cve_id("CVE-2007-3614");
  script_bugtraq_id(24773);
  script_xref(name:"OSVDB", value:"37838");

  script_name(english:"SAP DB / MaxDB Web Server DBM_INTERN_TEST Event Buffer Overflow Vulnerability");
  script_summary(english:"Checks version of Web DBM");

  script_description(english:desc);

  script_category(ACT_GATHER_INFO);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 9999);

  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:9999);
if (!get_port_state(port)) exit(0);


# Make sure the banner indicates it's Web DBM.
banner = get_http_banner(port:port);
if (!banner || "Server: SAP-Internet-SapDb-Server" >!< banner) exit(0);


# Get the version number.
req = http_get(item:"/webdbm?Page=VERSION", port:port);
res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
if (res == NULL) exit(0);

ver = NULL;
build = NULL;
pat = '<td class="(dbmSTbvCellStd|dbmSTbvCellLast|table[0-9]).*>(&nbsp;)*([0-9][0-9.-]+) *(&nbsp;)*</';
matches = egrep(pattern:pat, string:res);
if (matches)
{
  foreach match (split(matches))
  {
    match = chomp(match);
    m = eregmatch(pattern:pat, string:match);
    if (!isnull(m))
    {
      if ("table" >< m[1] && m[3] !~ "^[0-9]{3}-") ver = chomp(m[3]);
      if ("CellStd" >< m[1]) ver = chomp(m[3]);
      if ("CellLast" >< m[1] || ("table" >< m[1] && m[3] =~ "^[0-9]{3}-"))
      {
        build = m[3];
        if (build =~ "^([0-9][0-9][0-9])-.*")
        {
          build = ereg_replace(pattern:"^([0-9][0-9][0-9])-.*", replace:"\1", string:build);
          build = int(build);
        }
      }
    }
  }
}
if (isnull(ver)) exit(0);
if (!isnull(build)) ver += "." + build;


# There's a problem if the version is under 7.5.0.44 / 7.6.00.37.
iver = split(ver, sep:'.', keep:FALSE);
if (
  int(iver[0]) < 7 ||
  (
    int(iver[0]) == 7 &&
    (
      int(iver[1]) < 5 ||
      (int(iver[1]) == 5 && int(iver[2]) == 0 && !isnull(iver[3]) && int(iver[3]) < 44) ||
      (int(iver[1]) == 6 && int(iver[2]) == 0 && !isnull(iver[3]) && int(iver[3]) < 37)
    )
  )
)
{
  report = string(
    desc,
    "\n\n",
    "Plugin output :\n",
    "\n",
    "According to its banner, MaxDB / SAP DB version ", ver, " is installed\n",
    "on the remote host.\n"
  );
  security_hole(port:port, data:report);
}
