#
# (C) Tenable Network Security
#
#
desc["english"] = "
Synopsis :

The remote web server seems to have been compromised by a worm

Description :

The remote web site seems to link to malicious javascript files hosted
on a third party web site.

This means that the remote web site has been compromised, and it
might infect its visitors as well.

This indicates that the remote web site is vulnerable to SQL injection
attacks.

Solution :

Restore your web site to its original state, and audit your dynamic
pages for SQL injection vulnerabilities.

See also :

http://isc.sans.org/diary.html?storyid=3810
http://www.nessus.org/u?d8fa1760

Risk factor :

Critical / CVSS Base Score : 10.0
(CVSS2#AV:N/AC:L/Au:N/C:C/I:C/A:C)";



if(description)
{
 script_id(29871);
 script_version ("$Revision: 1.1 $");
 
 name["english"] = "Web Site contains links to malicious javascript files";
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "This plugin uses the results of webmirror.nasl";
 
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc.");
 family["english"] = "CGI abuses";
 script_family(english:family["english"]);
 script_dependencie("webmirror.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if(!port || !get_port_state(port))exit(0);

list = get_kb_list("www/" + port + "/infected/uc8010");
if ( isnull(list) ) exit(0);
list = make_list(list);
foreach item ( list )
{
 if ( item =~ "link: " ) 
 {
  item = str_replace(find:"page:", replace:"The URL http://" + get_host_name() + "/", string:item);
  item = str_replace(find:"link:", replace:"links to:", string:item);
  report += item + '\n';
 }
}

if ( strlen(report) )
 security_hole(port:port, data:desc["english"] + '\n\nPlugin output :\n\n' + report);
