#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10317);
 script_bugtraq_id(373);
 script_version ("$Revision: 1.28 $");
 script_cve_id("CVE-1999-0149");
 script_xref(name:"OSVDB", value:"247");
 
 name["english"] = "wrap";
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote web server contains a CGI script that is prone to
information disclosure. 

Description :

The 'wrap' CGI is installed.  This CGI allows anyone to get a listing
for any directory with mode +755. 

Note that not all implementations of 'wrap' are vulnerable.

See also : 

http://seclists.org/lists/bugtraq/1997/Apr/0076.html
   
Solution : 

Remove this CGI script.

Risk factor : 

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:P/I:N/A:N)";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the presence of /cgi-bin/wrap";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 1999 Renaud Deraison");
 family["english"] = "CGI abuses";
 script_family(english:family["english"]);
 script_dependencie("find_service1.nasl", "no404.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#
include("http_func.inc");
include("http_keepalive.inc");
include("global_settings.inc");

if ( report_paranoia < 2 ) exit(0);

port = get_http_port(default:80);
res = is_cgi_installed_ka(port:port, item:"wrap");
if(res)security_warning(port);

