#
#  (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(29825);
  script_version("$Revision: 1.2 $");

  script_cve_id("CVE-2007-6530");
  script_bugtraq_id(27025);
  script_xref(name:"OSVDB", value:"39901");

  script_name(english:"XUpload ActiveX Control AddFolder Buffer Overflow Vulnerability");
  script_summary(english:"Checks version of XUpload ActiveX control"); 
 
 desc = "
Synopsis :

The remote Windows host has an ActiveX control that is affected by a
buffer overflow vulnerability. 

Description :

The remote host contains a version of the XUpload ActiveX control from
Persits Software that reportedly is affected by a buffer overflow in
its 'AddFolder' method that can be triggered by a long argument.  If a
remote attacker can trick a user on the affected host into visiting a
specially-crafted web page, he may be able to leverage this issue to
execute arbitrary code on the affected host subject to the user's
privileges. 

See also :

http://archives.neohapsis.com/archives/fulldisclosure/2007-12/0561.html
http://www.milw0rm.com/exploits/4806

Solution :

If using Persits Software XUpload, upgrade to version 3.0.0.0 or later
as that reportedly resolves the issue. 

If using Mercury LoadRunner, set the kill-bit for the affected
control. 

Risk factor :

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc.");

  script_dependencies("smb_hotfixes.nasl");
  script_require_keys("SMB/Registry/Enumerated");
  script_require_ports(139, 445);

  exit(0);
}


include("global_settings.inc");
include("smb_func.inc");
include("smb_activex_func.inc");


if (!get_kb_item("SMB/Registry/Enumerated")) exit(0);


# Locate the file used by the controls.
if (activex_init() != ACX_OK) exit(0);

clsid = "{E87F6C8E-16C0-11D3-BEF7-009027438003}";
file = activex_get_filename(clsid:clsid);
if (file && file =~ "\xupload")
{
  # Check its version.
  ver = activex_get_fileversion(clsid:clsid);
  if (ver && activex_check_fileversion(clsid:clsid, fix:"3.0.0.0") == TRUE)
  {
    report = NULL;
    if (report_paranoia > 1)
      report = string(
        "Version ", ver, " of the vulnerable control is installed as :\n",
        "\n",
        "  ", file, "\n",
        "\n",
        "Note, though, that Nessus did not check whether the 'kill' bit was\n",
        "set for the control's CLSID because of the Report Paranoia setting\n",
        "in effect when this scan was run.\n"
      );
    else if (activex_get_killbit(clsid:clsid) != TRUE)
      report = string(
        "Version ", ver, " of the vulnerable control is installed as :\n",
        "\n",
        "  ", file, "\n",
        "\n",
        "Moreover, its 'kill' bit is not set so it is accessible via Internet\n",
        "Explorer.\n"
      );
    if (report) security_hole(port:kb_smb_transport(), extra:report);
  }
}
activex_end();
