#
# (C) Tenable Network Security, Inc.
#

 desc = "
Synopsis :

The remote Windows host contains an instant-messaging application. 

Description :

Yahoo! Messenger, an instant-messaging application, is installed on
the Windows host. 

See also :

http://messenger.yahoo.com/

Solution :

Make sure the use of this program is in accordance with your corporate
security policy. 

Risk factor :

None";


if(description)
{
  script_id(11432);
  script_version("$Revision: 1.12 $");

  script_name(english:"Yahoo! Messenger Detection");
  script_summary(english:"Detects Yahoo! Messenger");
 
  script_description(english:desc);

  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2003-2007 Tenable Network Security, Inc.");

  script_dependencies("smb_hotfixes.nasl");
  script_require_keys("SMB/Registry/Enumerated");
  script_require_ports(139, 445);

  exit(0);
}


if (!get_kb_item("SMB/Registry/Enumerated")) exit(0);



include("global_settings.inc");
include("smb_func.inc");

debug_level = 2;
report_paranoia = 2;


# Unless we're being paranoid, do a quick check for the install.
if (report_paranoia < 2)
{
  key = "SMB/Registry/HKLM/SOFTWARE/Microsoft/Windows/CurrentVersion/Uninstall/Yahoo! Messenger/DisplayName";
  if (!get_kb_item(key)) exit(0);
}


# Connect to the appropriate share.
if (!get_kb_item("SMB/Registry/Enumerated")) exit(0);
name    =  kb_smb_name();
port    =  kb_smb_transport();
if (!get_port_state(port)) exit(0);
login   =  kb_smb_login();
pass    =  kb_smb_password();
domain  =  kb_smb_domain();

soc = open_sock_tcp(port);
if (!soc) exit(0);

session_init(socket:soc, hostname:name);
rc = NetUseAdd(login:login, password:pass, domain:domain, share:"IPC$");
if (rc != 1)
{
  NetUseDel();
  exit(0);
}


# Connect to remote registry.
hklm = RegConnectRegistry(hkey:HKEY_LOCAL_MACHINE);
if (isnull(hklm))
{
  NetUseDel();
  exit(0);
}


# Check whether it's installed.
path = NULL;

key = "SOFTWARE\Classes\ymsgr\shell\open\command";
key_h = RegOpenKey(handle:hklm, key:key, mode:MAXIMUM_ALLOWED);
if (!isnull(key_h))
{
  value = RegQueryValue(handle:key_h, item:NULL);
  if (!isnull(value))
  {
    exe = ereg_replace(pattern:'^"([^"]+)".*', replace:"\1", string:value[1]);
    path = ereg_replace(pattern:"^(.+)\\Y(ahooMessenger|Pager)\.exe$", replace:"\1", string:exe, icase:TRUE);
  }

  RegCloseKey(handle:key_h);
}
RegCloseKey(handle:hklm);
if (isnull(path))
{
  NetUseDel();
  exit(0);
}


# Check the version of the main exe.
share = ereg_replace(pattern:"^([A-Za-z]):.*", replace:"\1$", string:exe);
exe2 =  ereg_replace(pattern:"^[A-Za-z]:(.*)", replace:"\1", string:exe);
NetUseDel(close:FALSE);

rc = NetUseAdd(login:login, password:pass, domain:domain, share:share);
if (rc != 1)
{
  NetUseDel();
  exit(0);
}

fh = CreateFile(
  file:exe2,
  desired_access:GENERIC_READ,
  file_attributes:FILE_ATTRIBUTE_NORMAL,
  share_mode:FILE_SHARE_READ,
  create_disposition:OPEN_EXISTING
);
ver = NULL;
if (!isnull(fh))
{
  ver = GetFileVersion(handle:fh);
  CloseFile(handle:fh);
}


# Clean up.
NetUseDel();


# Update KB and report findings.
if (!isnull(ver))
{
  version = string(ver[0], ".", ver[1], ".", ver[2], ".", ver[3]);

  set_kb_item(name:"SMB/Yahoo/Messenger/Path", value:path);
  set_kb_item(name:"SMB/Yahoo/Messenger/Version", value:version);

  report = string(
    desc,
    "\n\n",
    "Plugin output :\n",
    "\n",
    "Yahoo! Messenger ", version, " is installed on the remote host under :\n",
    "\n",
    "  ", path
  );
  security_note(port:port, data:report);
}
