#
#  (C) Tenable Network Security, Inc.
#


 desc = "
Synopsis :

The instant messaging application on the remote Windows host is
affected by multiple vulnerabilities. 

Description :

The version of Yahoo! Messenger installed on the remote host is
reportedly affected by a buffer overflow as well as a denial of
service vulnerability, both involving its video chat feature. 

If an attacker can trick a user on the affected host into accepting a
webcam invitation, he may be able to leverage these issues to crash
the affected application or execute arbitrary code on the host subject
to the user's privileges. 

See also :

http://messenger.yahoo.com/security_update.php?id=082107

Solution :

Upgrade to Yahoo! Messenger version 8.1.0.416 or later. 

Risk factor : 

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";


if (description)
{
  script_id(25932);
  script_version("$Revision: 1.4 $");

  script_cve_id("CVE-2007-4391");
  script_bugtraq_id(25330);
  script_xref(name:"OSVDB", value:"38221");

  script_name(english:"Yahoo! Messenger < 8.1.0.416 Multiple Vulnerabilities");
  script_summary(english:"Checks version of Yahoo! Messenger"); 
 
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("yahoo_installed.nasl");
  script_require_keys("SMB/Yahoo/Messenger/Version");

  exit(0);
}


ver = get_kb_item("SMB/Yahoo/Messenger/Version");
if (isnull(ver)) exit(0);

iver = split(ver, sep:'.', keep:FALSE);
for (i=0; i<max_index(iver); i++)
  iver[i] = int(iver[i]);

fix = split("8.1.0.416", sep:'.', keep:FALSE);
for (i=0; i<4; i++)
  fix[i] = int(fix[i]);

for (i=0; i<max_index(iver); i++)
  if ((iver[i] < fix[i]))
  {
    report = string(
      desc,
      "\n\n",
      "Plugin output :\n",
      "\n",
      "Version ", ver, " of Yahoo! Messenger is currently installed on\n",
      "the remote host.\n"
    );
    security_hole(port:get_kb_item("SMB/transport"), data:report);
    break;
  }
  else if (iver[i] > fix[i])
    break;
