#
#  (C) Tenable Network Security, Inc.
#


 desc = "
Synopsis :

The remote Windows host has an ActiveX control that is affected by a
buffer overflow vulnerability. 

Description :

The remote host contains the YDP ActiveX control, distributed as a
part of Yahoo! Widgets. 

The version of this control installed on the remote host reportedly
fails to validate input to the 'GetComponentVersion' method before
storing it in a 512-byte buffer.  If an attacker can trick a user on
the affected host into visiting a specially-crafted web page, he may
be able to leverage this issue to execute arbitrary code on the host
subject to the user's privileges. 

See also :

http://help.yahoo.com/l/us/yahoo/widgets/security/security-08.html

Solution :

Either disable the use of this ActiveX control from within Internet
Explorer by setting its 'kill' bit or upgrade to Yahoo! Widgets
version 4.0.5 (version 2007.7.13.3 of the YDP control itself) or
later. 

Risk factor :

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";


if (description)
{
  script_id(25798);
  script_version("$Revision: 1.5 $");

  script_cve_id("CVE-2007-4034");
  script_bugtraq_id(25086);
  script_xref(name:"OSVDB", value:"37705");

  script_name(english:"Yahoo! Widgets YDP ActiveX Buffer Overflow Vulnerability");
  script_summary(english:"Checks versions of YDP ActiveX control"); 
 
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("smb_hotfixes.nasl");
  script_require_keys("SMB/Registry/Enumerated");
  script_require_ports(139, 445);

  exit(0);
}


include("global_settings.inc");
include("smb_func.inc");
include("smb_activex_func.inc");


if (!get_kb_item("SMB/Registry/Enumerated")) exit(0);


# Locate files used by the controls.
if (activex_init() != ACX_OK) exit(0);

clsid = "{7EC7B6C5-25BD-4586-A641-D2ACBB6629DD}";
file = activex_get_filename(clsid:clsid);
if (file)
{
  ver = activex_get_fileversion(clsid:clsid);
  if (ver && activex_check_fileversion(clsid:clsid, fix:"2007.7.13.3") == TRUE)
  {
    report = NULL;
    if (report_paranoia > 1)
      report = string(
        desc,
        "\n\n",
        "Plugin output :\n",
        "\n",
        "Version ", ver, " of the vulnerable control is installed as :\n",
        "\n",
        "  ", file, "\n",
        "\n",
        "Note, though, that Nessus did not check whether the 'kill' bit was\n",
        "set for the control's CLSID because of the Report Paranoia setting\n",
        "in effect when this scan was run.\n"
      );
    else if (activex_get_killbit(clsid:clsid) != TRUE)
      report = string(
        desc,
        "\n\n",
        "Plugin output :\n",
        "\n",
        "Version ", ver, " of the vulnerable control is installed as :\n",
        "\n",
        "  ", file, "\n",
        "\n",
        "Moreover, its 'kill' bit is not set so it is accessible via\n",
        "Internet Explorer."
      );
    if (report) security_hole(port:kb_smb_transport(), data:report);
  }
}
activex_end();
