#
#  (C) Tenable Network Security
#


 desc = "
Synopsis :

The remote Windows host contains a library that is affected by a
buffer overflow vulnerability. 

Description :

The remote host contains a version of the open-source 7-Zip file
archiver and included in third-party products such as Knownsoft's
Turbo Searcher. 

The version of this software installed on the remote host contains a
buffer overflow in its ARJ file handling library that is triggered
when handling an ARJ block greater than 2600 bytes.  If an attacker
can trick a user on the affected host into opening a specially-crafted
ARJ archive file, he can leverage this issue to execute arbitrary code
on the host subject to the user's privileges. 

See also :

http://secunia.com/secunia_research/2005-45/advisory/
http://www.securityfocus.com/archive/1/411522/30/0/threaded
http://sourceforge.net/project/shownotes.php?release_id=347504
http://vuln.sg/turbosearcher330-en.html

Solution :

Either contact the application's vendor for an update or upgrade to
7-Zip 4.27 beta (4.27.0.0) or later. 

Risk factor : 

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";


if (description)
{
  script_id(23750);
  script_version("$Revision: 1.4 $");

  script_cve_id("CVE-2005-3051");
  script_bugtraq_id(14925, 21208);

  script_name(english:"7-Zip ARJ File Overflow Vulnerability");
  script_summary(english:"Checks version of arj.dll from 7-Zip"); 

  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2006-2008 Tenable Network Security");

  script_dependencies("smb_hotfixes.nasl");
  script_require_keys("SMB/Registry/Enumerated");
  script_require_ports(139, 445);

  exit(0);
}


include("global_settings.inc");
include("smb_func.inc");


# Connect to the appropriate share.
if (!get_kb_item("SMB/Registry/Enumerated")) exit(0);
name    =  kb_smb_name();
port    =  kb_smb_transport();
if (!get_port_state(port)) exit(0);
login   =  kb_smb_login();
pass    =  kb_smb_password();
domain  =  kb_smb_domain();

soc = open_sock_tcp(port);
if (!soc) exit(0);

session_init(socket:soc, hostname:name);
rc = NetUseAdd(login:login, password:pass, domain:domain, share:"IPC$");
if (rc != 1)
{
  NetUseDel();
  exit(0);
}


# Connect to remote registry.
hklm = RegConnectRegistry(hkey:HKEY_LOCAL_MACHINE);
if (isnull(hklm))
{
  NetUseDel();
  exit(0);
}


# Check whether it's installed.
paths =  make_array();
# - 7-Zip itself
prod = "7-Zip";
key = "SOFTWARE\7-Zip";
key_h = RegOpenKey(handle:hklm, key:key, mode:MAXIMUM_ALLOWED);
if (!isnull(key_h))
{
  value = RegQueryValue(handle:key_h, item:"Path");
  if (!isnull(value)) paths[prod] = value[1];

  RegCloseKey(handle:key_h);
}
# - Turbo Searcher
prod = "Turbo Searcher";
key = "SOFTWARE\Classes\folder\shellex\ContextMenuHandlers\Turbo Searcher";
key_h = RegOpenKey(handle:hklm, key:key, mode:MAXIMUM_ALLOWED);
if (!isnull(key_h))
{
  value = RegQueryValue(handle:key_h, item:NULL);
  if (!isnull(value)) clsid = value[1];

  RegCloseKey(handle:key_h);

  if (!isnull(clsid))
  {
    key = "SOFTWARE\Classes\CLSID\" + clsid + "\InprocServer32";
    key_h = RegOpenKey(handle:hklm, key:key, mode:MAXIMUM_ALLOWED);
    if (!isnull(key_h))
    {
      value = RegQueryValue(handle:key_h, item:NULL);
      if (!isnull(value)) paths[prod] = ereg_replace(pattern:"^(.+)\\[^\\]+\.dll", replace:"\1", string:value[1]);

      RegCloseKey(handle:key_h);
    }
  }
}
RegCloseKey(handle:hklm);
if (max_index(keys(paths)) == 0) {
  NetUseDel();
  exit(0);
}


# Check the version of 'arj.dll' in each product.
info = "";
foreach prod (keys(paths))
{
  # Determine the version from the DLL itself.
  path = paths[prod];
  share = ereg_replace(pattern:"^([A-Za-z]):.*", replace:"\1$", string:path);
  dll =  ereg_replace(pattern:"^[A-Za-z]:(.*)", replace:"\1\Formats\arj.dll", string:path);
  NetUseDel(close:FALSE);

  rc = NetUseAdd(login:login, password:pass, domain:domain, share:share);
  if (rc != 1)
  {
    NetUseDel();
    exit(0);
  }

  fh = CreateFile(
    file:dll,
    desired_access:GENERIC_READ,
    file_attributes:FILE_ATTRIBUTE_NORMAL,
    share_mode:FILE_SHARE_READ,
    create_disposition:OPEN_EXISTING
  );
  ver = NULL;
  if (!isnull(fh))
  {
    ver = GetFileVersion(handle:fh);
    CloseFile(handle:fh);
  }

  # Check the version number.
  if (!isnull(ver))
  {
    fix = split("4.27.0.0", sep:'.', keep:FALSE);
    for (i=0; i<4; i++)
      fix[i] = int(fix[i]);

    for (i=0; i<max_index(ver); i++)
      if ((ver[i] < fix[i]))
      {
        version = string(ver[0], ".", ver[1], ".", ver[2], ".", ver[3]);
        info += "  " + path + "\Formats\arj.dll (file version=" + version + ')\n';
        break;
      }
      else if (ver[i] > fix[i])
        break;
  }
}


# Issue a report if any vulnerable files were found.
if (info)
{
    report = desc + string(
      "\n\n",
      "Plugin output :\n",
      "\n",
      "The following files are affected :\n",
      "\n",
      info
    );
  security_hole(port:port, data:report);
}

# Clean up.
NetUseDel();
