#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
# and is based on BEA_weblogic_Reveal_source_code.nasl
#
# Script audit and contributions from Carmichael Security <http://www.carmichaelsecurity.com>
#      Erik Anderson <eanders@carmichaelsecurity.com>
#      Added BugtraqID
#
# See the Nessus Scripts License for details
#



if(description)
{

script_id(11604);
script_version("$Revision: 1.10 $");

script_cve_id("CVE-2000-0683");
script_bugtraq_id(1517);
script_xref(name:"OSVDB", value:"1480");

name["english"]="BEA WebLogic Scripts Server scripts Source Disclosure (3)";
script_name(english:name["english"], francais:name["francais"]);
desc["english"]="
Synopsis :

The remote web server is affected by an information disclosure
vulnerability. 

Description :

BEA WebLogic may be tricked into revealing the source code of JSP
scripts by prefixing the path to the .jsp files by /*.shtml/

See also :

http://archives.neohapsis.com/archives/bugtraq/2000-07/0410.html
http://dev2dev.bea.com/pub/advisory/12

Solution: 

Apply the appropriate Service Pack according to the vendor advisory
referenced above. 

Risk factor : 

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:P/I:N/A:N)";
script_description(english:desc["english"]);

summary["english"]="BEA WebLogic may be tricked into revealing the source code of JSP scripts.";
script_summary(english:summary["english"]);

script_category(ACT_GATHER_INFO);
script_copyright(english:"This script is (C) 2003 Renaud Deraison");

family["english"]="CGI abuses";
script_family(english:family["english"]);
 

script_dependencie("find_service1.nasl", "http_version.nasl", "webmirror.nasl");
script_require_ports("Services/www", 80);

exit(0);
}

include("http_func.inc");

function check(req, port)
{ 
local_var soc, request, response, signature;
soc = http_open_socket(port);
if(!soc) return(0); 

request = http_get(item:req, port:port); 
send(socket:soc, data:request);
response = http_recv(socket:soc);
http_close_socket(soc); 


#signature of Jsp.

signature = "<%=";

if (signature >< response) return(1);
 
return(0);
}

port = get_http_port(default:80);



if(!get_port_state(port)) exit(0);
if ( get_kb_item("Services/www/" + port + "/embedded") ) exit(0);

sig = get_kb_item("www/hmap/" + port + "/description");
if ( sig && "WebLogic" >!< sig ) exit(0);

# Try with a known jsp file

files = get_kb_list(string("www/", port, "/content/extensions/jsp"));
if(isnull(files))file = "/index.jsp";
else
 {
 files = make_list(files);
 file = files[0];
 }
 
if(check(req:string("/*.shtml/", file), port:port))security_warning(port);
