#
# (C) Tenable Network Security
#


if(description)
{
 script_id(24736);
 script_cve_id("CVE-2007-1258");
 script_bugtraq_id(22750);
 script_version("$Revision: 1.4 $");

 name["english"] = "Cisco Catalyst MPLS Packet Handling Denial of Service Vulnerability";

 script_name(english:name["english"]);

 desc["english"] = "
Synopsis :

The remote switch can be crashed remotely.

Description :

The remote host is a CISCO Catalyst 6500 switch containing a version of IOS 
which is vulnerable to a denial of service vulnerability when processing 
malformed MPLS packets.

An attacker may exploit this flaw to crash the remote device.

Solution :

http://www.cisco.com/warp/public/707/cisco-sa-20070228-mpls.shtml

Risk factor :

Medium / CVSS Base Score : 6.1
(CVSS2#AV:A/AC:L/Au:N/C:N/I:N/A:C)";


 script_description(english:desc["english"]);

 summary["english"] = "Uses SNMP to determine if a flaw is present";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");

 script_family(english:"CISCO");

 script_dependencie("snmp_sysDesc.nasl", "snmp_cisco_type.nasl");
 script_require_keys("SNMP/community", "SNMP/sysDesc", "CISCO/model");
 exit(0);
}


include('cisco_func.inc');

os = get_kb_item("SNMP/sysDesc"); if(!os)exit(0);
if(!egrep(pattern:".*(Internetwork Operating|IOS).*", string:os)) exit(0);
hardware = get_kb_item("CISCO/model"); if(!hardware)exit(0);
if(!ereg(string:hardware, pattern:"^cat6500.*$"))exit(0);

version = extract_version(os);
if ( ! version ) exit(0);




if ( deprecated_version(version, "12.2SXA") ) vuln ++;


if ( check_release(version:version, 
		   patched:make_list("12.2(17d)SXB5"),
		   newest:"12.2(17d)SXB5") ) vuln ++;

if ( check_release(version:version, 
		   patched:make_list("12.2(18)SXD3"),
		   newest:"12.2(18)SXD3") ) vuln ++;

if ( check_release(version:version, 
		   patched:make_list("12.2(18)SXF5"),
		   newest:"12.2(18)SXF5") ) vuln ++;



if ( vuln == 1 ) security_warning(port:161, proto:"udp");
else if ( vuln > 1 )  display("Problem in script $Id: CSCef90002.nasl,v 1.4 2007/08/23 01:54:43 theall Exp $\n");


