# This script was written by Michel Arboi (GPL)

 desc["english"] = "
Synopsis :

The remote system can be accessed with default admin credentials. 

Description :

The account 'debug' on the remote host uses the password 'synnet'.  
An attacker may use it to gain further privileges on this system. 

See also :

http://archives.neohapsis.com/archives/bugtraq/1998_2/0245.html

Solution :

Set a strong password for this account or disable it.  This may
disable dependent applications so beware. 

Risk factor :

Critical / CVSS Base Score : 10.0
(CVSS2#AV:N/AC:L/Au:N/C:C/I:C/A:C)";

account = "debug";
password = "synnet";

if(description)
{
 script_id(17289);
 script_version ("$Revision: 1.8 $");

 script_bugtraq_id(88);
 
 script_name(english:"Default password ('synnet') for 'debug' account");
 script_description(english:desc["english"]);
 
 script_summary(english:"Logs into the remote host");
 script_category(ACT_GATHER_INFO);

 script_family(english:"Default Unix Accounts");
 
 script_copyright(english:"This script is Copyright (C) 2005-2007 Michel Arboi");
 
 script_dependencie("find_service1.nasl", "ssh_detect.nasl");
 script_require_ports("Services/telnet", 23, "Services/ssh", 22);
 script_require_keys("Settings/ThoroughTests");
 exit(0);
}

#
include("default_account.inc");
include("global_settings.inc");

if ( ! thorough_tests ) exit(0);

port = check_account(login:account, password:password);
if(port)security_hole(port);
