# This script was written by Michel Arboi

 desc["english"] = "
Synopsis :

The remote system can be accessed with a default account. 

Description :

The account 'help' on the remote host does not have a password set. 
An attacker may use it to gain further privileges on this system. 

Solution : 

Set a password for this account or disable it.

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";

account = "help";

if(description)
{
 script_id(17575);
 script_version ("$Revision: 1.7 $");
 script_bugtraq_id(247);
 
 script_name(english:"Unpassworded help account");
 script_description(english:desc["english"]);
		 
 script_summary(english:"Logs into the remote host");
 script_category(ACT_GATHER_INFO);

 script_family(english:"Default Unix Accounts");
 
 script_copyright(english:"This script is Copyright (C) 2005-2007 Michel Arboi");
 
 
 script_dependencie("find_service1.nasl", "ssh_detect.nasl");
 script_require_ports("Services/telnet", 23, "Services/ssh", 22);
 script_require_keys("Settings/ThoroughTests");

 exit(0);
}

#
# The script code starts here : 
#
include("default_account.inc");
include("global_settings.inc");

if ( ! thorough_tests ) exit(0);

port = check_account(login:account);
if(port)security_hole(port);
